/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractClient;
import com.obs.services.AbstractObjectClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.File;
import java.io.InputStream;

public abstract class AbstractMultipartObjectClient
extends AbstractObjectClient {
    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(final InitiateMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "InitiateMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("initiateMultipartUpload", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult action() throws ServiceException {
                return AbstractMultipartObjectClient.this.initiateMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse abortMultipartUpload(final AbortMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "AbortMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("abortMultipartUpload", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractMultipartObjectClient.this.abortMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, InputStream input) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setInput(input);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, File file) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setFile(file);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(final UploadPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "UploadPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("uploadPart", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<UploadPartResult>(){

            @Override
            public UploadPartResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return AbstractMultipartObjectClient.this.uploadPartImpl(request);
            }
        });
    }

    @Override
    public CopyPartResult copyPart(final CopyPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CopyPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("copyPart", request.getSourceBucketName(), new AbstractClient.ActionCallbackWithResult<CopyPartResult>(){

            @Override
            public CopyPartResult action() throws ServiceException {
                return AbstractMultipartObjectClient.this.copyPartImpl(request);
            }
        });
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(final CompleteMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CompleteMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("completeMultipartUpload", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult action() throws ServiceException {
                return AbstractMultipartObjectClient.this.completeMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public ListPartsResult listParts(final ListPartsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListPartsRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("listParts", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ListPartsResult>(){

            @Override
            public ListPartsResult action() throws ServiceException {
                return AbstractMultipartObjectClient.this.listPartsImpl(request);
            }
        });
    }

    @Override
    public MultipartUploadListing listMultipartUploads(final ListMultipartUploadsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListMultipartUploadsRequest is null");
        return this.doActionWithResult("listMultipartUploads", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<MultipartUploadListing>(){

            @Override
            public MultipartUploadListing action() throws ServiceException {
                return AbstractMultipartObjectClient.this.listMultipartUploadsImpl(request);
            }
        });
    }
}

