/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.geometric;

import com.highgo.jdbc.geometric.PGpoint;
import com.highgo.jdbc.util.PGobject;
import com.highgo.jdbc.util.PGtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint @Nullable [] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpolygon() {
        this.type = "polygon";
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        PGpoint[] points = new PGpoint[npoints];
        this.points = points;
        for (int p = 0; p < npoints; ++p) {
            points[p] = new PGpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p = (PGpolygon)obj;
            if (this.points == null ^ p.points == null) {
                return false;
            }
            if (this.points == null) {
                return false;
            }
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        PGpoint[] points = this.points;
        if (points == null) {
            return hash;
        }
        for (int i = 0; i < points.length && i < 5; ++i) {
            hash = hash * 31 + points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            PGpoint[] newPoints = (PGpoint[])newPGpolygon.points.clone();
            newPGpolygon.points = newPoints;
            for (int i = 0; i < newPGpolygon.points.length; ++i) {
                if (newPGpolygon.points[i] == null) continue;
                newPoints[i] = (PGpoint)newPGpolygon.points[i].clone();
            }
        }
        return newPGpolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        PGpoint[] points = this.points;
        for (int p = 0; points != null && p < points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

