/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.core.v3;

import com.highgo.jdbc.bulkload.BulkloadOperation;
import com.highgo.jdbc.core.v3.QueryExecutorImpl;
import com.highgo.jdbc.jdbc.BulkloadResultHandler;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.internal.Nullness;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BulkloadOperationImpl
implements BulkloadOperation {
    @Nullable QueryExecutorImpl queryExecutor;
    int rowFormat;
    int @Nullable [] fieldFormats;
    long handledRowCount = -1L;
    BulkloadResultHandler bulkloadHandler;

    void init(BulkloadResultHandler handler, QueryExecutorImpl q, int fmt, int[] fmts) {
        this.bulkloadHandler = handler;
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    protected QueryExecutorImpl getQueryExecutor() {
        return Nullness.castNonNull(this.queryExecutor);
    }

    @Override
    public void cancelBulkload() throws SQLException {
        this.getQueryExecutor().cancelBulkload(this);
    }

    @Override
    public int getFieldCount() {
        return Nullness.castNonNull(this.fieldFormats).length;
    }

    @Override
    public int getFieldFormat(int field) {
        return Nullness.castNonNull(this.fieldFormats)[field];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = Nullness.castNonNull(this.queryExecutor);
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws PSQLException {
    }

    protected abstract void handleCopydata(byte[] var1) throws PSQLException;

    public long getHandledRowCount() {
        return this.handledRowCount;
    }

    @Override
    public ResultSet getHandledResultSet() {
        return this.bulkloadHandler.getResults().getResultSet();
    }
}

