/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.base.state.ESuccess;
import com.helger.pgcc.jjdoc.JJDocMain;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.AbstractToolFacade;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

class JJDoc
extends AbstractToolFacade {
    private File inputFile;
    private File outputFile;
    private String grammarEncoding;
    private String outputEncoding;
    private String cssHref;
    private Boolean text;
    private Boolean bnf;
    private Boolean oneTable;

    JJDoc() {
    }

    public void setInputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + String.valueOf(file));
        }
        this.inputFile = file;
    }

    public void setOutputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + String.valueOf(file));
        }
        this.outputFile = file;
    }

    public void setGrammarEncoding(String string) {
        this.grammarEncoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setCssHref(String string) {
        this.cssHref = string;
    }

    public void setText(Boolean bl) {
        this.text = bl;
    }

    public void setBnf(Boolean bl) {
        this.bnf = bl;
    }

    public void setOneTable(Boolean bl) {
        this.oneTable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ESuccess execute() throws Exception {
        File file;
        String[] stringArray = this._generateArguments();
        File file2 = file = this.outputFile != null ? this.outputFile.getParentFile() : null;
        if (file != null && !file.exists() && !file.mkdirs()) {
            this.getLog().error((CharSequence)("Failed to create output directory " + String.valueOf(file)));
            return ESuccess.FAILURE;
        }
        LOCK.lock();
        try {
            ESuccess eSuccess = JJDocMain.mainProgram((String[])stringArray);
            return eSuccess;
        }
        finally {
            LOCK.unlock();
        }
    }

    private String[] _generateArguments() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            arrayList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.outputEncoding)) {
            arrayList.add("-OUTPUT_ENCODING=" + this.outputEncoding);
        }
        if (this.text != null) {
            arrayList.add("-TEXT=" + this.text);
        }
        if (this.bnf != null) {
            arrayList.add("-BNF=" + this.bnf);
        }
        if (this.oneTable != null) {
            arrayList.add("-ONE_TABLE=" + this.oneTable);
        }
        if (this.outputFile != null) {
            arrayList.add("-OUTPUT_FILE=" + this.outputFile.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.cssHref)) {
            arrayList.add("-CSS=" + this.cssHref);
        }
        if (this.inputFile != null) {
            arrayList.add(this.inputFile.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return Arrays.asList(this._generateArguments()).toString();
    }

    class MojoLogStreamConsumer
    implements StreamConsumer {
        private static final String ERROR_PREFIX = "Error: ";
        private static final String WARN_PREFIX = "Warning: ";
        private final boolean err;

        public MojoLogStreamConsumer(boolean bl) {
            this.err = bl;
        }

        public void consumeLine(String string) {
            if (string.startsWith(ERROR_PREFIX)) {
                JJDoc.this.getLog().error((CharSequence)string.substring(ERROR_PREFIX.length()));
            } else if (string.startsWith(WARN_PREFIX)) {
                JJDoc.this.getLog().warn((CharSequence)string.substring(WARN_PREFIX.length()));
            } else if (this.err) {
                JJDoc.this.getLog().error((CharSequence)string);
            } else {
                JJDoc.this.getLog().debug((CharSequence)string);
            }
        }
    }
}

