/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.plexus.util.DirectoryScanner;

class GrammarDirectoryScanner {
    private final DirectoryScanner scanner = new DirectoryScanner();
    private File outputDirectory;
    private int staleMillis;
    private final List<GrammarInfo> includedGrammars;

    public GrammarDirectoryScanner() {
        this.scanner.setFollowSymlinks(true);
        this.includedGrammars = new ArrayList<GrammarInfo>();
    }

    public void setSourceDirectory(File file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("source directory is not absolute: " + String.valueOf(file));
        }
        this.scanner.setBasedir(file);
    }

    public void setIncludes(String[] stringArray) {
        this.scanner.setIncludes(stringArray);
    }

    public void setExcludes(String[] stringArray) {
        this.scanner.setExcludes(stringArray);
        this.scanner.addDefaultExcludes();
    }

    public void setOutputDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("output directory is not absolute: " + String.valueOf(file));
        }
        this.outputDirectory = file;
    }

    public void setStaleMillis(int n) {
        this.staleMillis = n;
    }

    public void scan() throws IOException {
        String[] stringArray;
        this.includedGrammars.clear();
        this.scanner.scan();
        block0: for (String string : stringArray = this.scanner.getIncludedFiles()) {
            GrammarInfo grammarInfo = new GrammarInfo(this.scanner.getBasedir(), string);
            if (this.outputDirectory != null) {
                File[] fileArray;
                File file = grammarInfo.getGrammarFile();
                for (File file2 : fileArray = this.getTargetFiles(this.outputDirectory, string, grammarInfo)) {
                    File file3 = file2;
                    if (file3.exists() && file3.lastModified() + (long)this.staleMillis >= file.lastModified()) continue;
                    this.includedGrammars.add(grammarInfo);
                    continue block0;
                }
                continue;
            }
            this.includedGrammars.add(grammarInfo);
        }
    }

    protected File[] getTargetFiles(File file, String string, GrammarInfo grammarInfo) {
        File file2 = new File(file, grammarInfo.getParserFile());
        return new File[]{file2};
    }

    public GrammarInfo[] getIncludedGrammars() {
        return this.includedGrammars.toArray(new GrammarInfo[this.includedGrammars.size()]);
    }
}

