/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.base.state.ESuccess;
import jakarta.annotation.Nonnull;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

abstract class AbstractToolFacade {
    protected static final Lock LOCK = new ReentrantLock();
    private Log m_aLog;

    AbstractToolFacade() {
    }

    public void setLog(Log log) {
        this.m_aLog = log;
    }

    protected final Log getLog() {
        if (this.m_aLog == null) {
            this.m_aLog = new SystemStreamLog();
        }
        return this.m_aLog;
    }

    protected String getToolName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Nonnull
    protected abstract ESuccess execute() throws Exception;

    public void run() throws MojoExecutionException, MojoFailureException {
        ESuccess eSuccess;
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Running " + this.getToolName() + ": " + String.valueOf(this)));
            }
            eSuccess = this.execute();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to execute " + this.getToolName(), exception);
        }
        if (eSuccess.isFailure()) {
            throw new MojoFailureException(this.getToolName() + " reported failure: " + String.valueOf(this));
        }
    }
}

