/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.structures;

import java.io.Serializable;

public class CompactArray
implements Serializable {
    float[] array;
    int offset;

    public CompactArray(int offset, float[] array) {
        this.offset = offset;
        this.array = array;
    }

    public void set(int index, float value) {
        if (index < this.offset + this.array.length && index >= this.offset) {
            int n = index - this.offset;
            this.array[n] = this.array[n] + value;
        } else if (index < this.offset) {
            int gap = this.offset - index;
            int newSize = gap + this.array.length;
            float[] newArray = new float[newSize];
            newArray[0] = value;
            for (int i = 0; i < this.array.length; ++i) {
                newArray[gap + i] = this.array[i];
            }
            this.offset = index;
            this.array = newArray;
        } else {
            int gap = index - (this.array.length + this.offset - 1);
            int newSize = this.array.length + gap;
            float[] newArray = new float[newSize];
            newArray[newSize - 1] = value;
            for (int i = 0; i < this.array.length; ++i) {
                newArray[i] = this.array[i];
            }
            this.array = newArray;
        }
    }

    public float[] getArray() {
        return this.array;
    }

    public int getOffset() {
        return this.offset;
    }

    public int length() {
        return this.array.length;
    }
}

