/*
 * Decompiled with CFR 0.152.
 */
package com.hackerrank.test.utility;

import com.hackerrank.test.utility.ReportGenerator;
import com.hackerrank.test.utility.TestObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TestWatchman
extends TestWatcher {
    public static final TestWatchman watchman = new TestWatchman();
    private static final Map<String, List<TestObject>> tests = new HashMap<String, List<TestObject>>();
    private String clazz = null;
    private TestObject test = null;

    public void registerClass(Class<?> clazz) {
        this.clazz = clazz.getCanonicalName();
        tests.put(this.clazz, new ArrayList());
    }

    protected void starting(Description description) {
        Long start = System.nanoTime();
        this.test = new TestObject(description.getMethodName(), start, 0L, "failed");
    }

    protected void finished(Description description) {
        this.test.setEnd(System.nanoTime());
        tests.get(this.clazz).add(this.test);
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        this.test.setTrace(ExceptionUtils.getStackTrace((Throwable)e));
        this.test.setEnd(System.nanoTime());
        this.test.setStatus("skipped");
        tests.get(this.clazz).add(this.test);
        System.out.println("\n\u001b[0;31m" + description.toString() + "\u001b[0m");
        System.out.println(String.join((CharSequence)"\n", Stream.of(ExceptionUtils.getStackTrace((Throwable)e).split("\n")).map(str -> "\u001b[0;31m" + str + "\u001b[0m").collect(Collectors.toList())));
    }

    protected void failed(Throwable e, Description description) {
        this.test.setTrace(ExceptionUtils.getStackTrace((Throwable)e));
        this.test.setEnd(System.nanoTime());
        System.out.println("\n\u001b[0;31m" + description.toString() + "\u001b[0m");
        System.out.println(String.join((CharSequence)"\n", Stream.of(ExceptionUtils.getStackTrace((Throwable)e).split("\n")).map(str -> "\u001b[0;31m" + str + "\u001b[0m").collect(Collectors.toList())));
    }

    protected void succeeded(Description description) {
        this.test.setEnd(System.nanoTime());
        this.test.setStatus("succeeded");
    }

    public boolean allTestsSucceeded() {
        return tests.get(this.clazz).stream().map(TestObject::getStatus).allMatch(status -> status.equals("succeeded"));
    }

    public void createReport(Class<?> clazz) {
        ReportGenerator.createReport(clazz, tests);
    }
}

