/*
 * Decompiled with CFR 0.152.
 */
package com.hackerrank.test.utility;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ResultMatcher {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static List<JsonNode> parseJsonArray(String jsonString) {
        try {
            return (List)OBJECT_MAPPER.readValue(jsonString, (TypeReference)new TypeReference<List<JsonNode>>(){});
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static List<JsonNode> sortJsonArray(List<JsonNode> jsonArray) {
        return jsonArray.stream().sorted(Comparator.comparing(JsonNode::toString)).collect(Collectors.toList());
    }

    private static boolean preliminaryJsonArrayMatching(List<JsonNode> response, List<JsonNode> expected) {
        if (response == null || expected == null) {
            return false;
        }
        return response.size() == expected.size();
    }

    private static boolean jsonArrayMatching(List<JsonNode> response, List<JsonNode> expected, boolean reportMismatch) {
        for (int i = 0; i < response.size(); ++i) {
            JsonNode responseJson;
            JsonNode expectedJson = expected.get(i);
            if (expectedJson.equals((Object)(responseJson = response.get(i)))) continue;
            if (reportMismatch) {
                System.out.println("\u001b[0;31mExpected <" + expectedJson.toString() + "> but was <" + responseJson.toString() + "> (at index " + i + ")." + "\u001b[0m");
            }
            return false;
        }
        return true;
    }

    public static boolean matchJsonArrayIgnoreOrder(String responseString, String expectedString, boolean reportMismatch) {
        List<JsonNode> expected;
        List<JsonNode> response = ResultMatcher.parseJsonArray(responseString);
        boolean preliminary = ResultMatcher.preliminaryJsonArrayMatching(response, expected = ResultMatcher.parseJsonArray(expectedString));
        if (!preliminary) {
            return false;
        }
        return ResultMatcher.jsonArrayMatching(ResultMatcher.sortJsonArray(response), ResultMatcher.sortJsonArray(expected), reportMismatch);
    }

    public static boolean matchJsonArray(String responseString, String expectedString, boolean reportMismatch) {
        List<JsonNode> expected;
        List<JsonNode> response = ResultMatcher.parseJsonArray(responseString);
        boolean preliminary = ResultMatcher.preliminaryJsonArrayMatching(response, expected = ResultMatcher.parseJsonArray(expectedString));
        if (!preliminary) {
            return false;
        }
        return ResultMatcher.jsonArrayMatching(response, expected, reportMismatch);
    }

    public static boolean matchJson(String responseString, String expectedString, boolean reportMismatch) {
        try {
            JsonNode response = OBJECT_MAPPER.readTree(responseString);
            JsonNode expected = OBJECT_MAPPER.readTree(expectedString);
            if (!response.equals((Object)expected)) {
                if (reportMismatch) {
                    System.out.println("\u001b[0;31mExpected <" + expectedString + "> but was <" + responseString + ">." + "\u001b[0m");
                }
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

