/*
 * Decompiled with CFR 0.152.
 */
package com.hackerrank.test.utility;

import com.hackerrank.test.utility.NumberFormatter;
import com.hackerrank.test.utility.TestObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ReportGenerator {
    public static void createReport(Class<?> clazz, Map<String, List<TestObject>> suiteTests) {
        String className = clazz.getCanonicalName();
        Document report = new Document();
        if (suiteTests.containsKey(className)) {
            report.setRootElement(ReportGenerator.createReport(className, suiteTests.get(className)));
        } else {
            Element testsuites = new Element("testsuites");
            int totalTest = 0;
            int failures = 0;
            int errors = 0;
            double executionTime = 0.0;
            for (Map.Entry<String, List<TestObject>> entry : suiteTests.entrySet()) {
                String name = entry.getKey();
                List<TestObject> tests = entry.getValue();
                Element testsuite = ReportGenerator.createReport(name, tests);
                totalTest += Integer.parseInt(testsuite.getAttribute("tests").getValue());
                failures += Integer.parseInt(testsuite.getAttribute("failures").getValue());
                errors += Integer.parseInt(testsuite.getAttribute("errors").getValue());
                executionTime += Double.parseDouble(testsuite.getAttribute("time").getValue());
                testsuites.addContent((Content)testsuite);
            }
            Attribute name = new Attribute("name", className);
            Attribute testCount = new Attribute("tests", String.valueOf(totalTest));
            Attribute failureCount = new Attribute("failures", String.valueOf(failures));
            Attribute errorCount = new Attribute("errors", String.valueOf(errors));
            Attribute skippedCount = new Attribute("skipped", "0");
            Attribute time = new Attribute("time", NumberFormatter.stringValue(executionTime, 3));
            testsuites.setAttribute(name);
            testsuites.setAttribute(testCount);
            testsuites.setAttribute(failureCount);
            testsuites.setAttribute(errorCount);
            testsuites.setAttribute(skippedCount);
            testsuites.setAttribute(time);
            report.setRootElement(testsuites);
        }
        String reportPath = "target/hackerrank-reports";
        File file = new File(reportPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        try {
            outputter.output(report, (Writer)new FileWriter(new File(reportPath + "/TEST-" + className + ".xml")));
        }
        catch (IOException ex) {
            System.out.println(String.join((CharSequence)"\n", Stream.of(ExceptionUtils.getStackTrace((Throwable)ex).split("\n")).map(str -> "\u001b[0;31m" + str + "\u001b[0m").collect(Collectors.toList())));
        }
    }

    private static Element createReport(String className, List<TestObject> tests) {
        Element testsuite = new Element("testsuite");
        int failures = 0;
        int errors = 0;
        double executionTime = 0.0;
        for (TestObject test : tests) {
            String trace;
            Element testcase = new Element("testcase");
            Attribute classname = new Attribute("classname", className);
            Attribute name = new Attribute("name", test.getName());
            double testTime = test.getExecutionTime();
            executionTime += testTime;
            Attribute time = new Attribute("time", String.valueOf(testTime));
            testcase.setAttribute(classname);
            testcase.setAttribute(name);
            testcase.setAttribute(time);
            String status = test.getStatus();
            if (status.equals("failed")) {
                ++failures;
                Element failure = new Element("failure");
                trace = test.getTrace();
                if (trace != null) {
                    failure.addContent(trace);
                }
                testcase.addContent((Content)failure);
            } else if (status.equals("skipped")) {
                ++errors;
                Element error = new Element("error");
                trace = test.getTrace();
                if (trace != null) {
                    error.addContent(trace);
                }
                testcase.addContent((Content)error);
            }
            testsuite.addContent((Content)testcase);
        }
        Attribute name = new Attribute("name", className);
        Attribute testCount = new Attribute("tests", String.valueOf(tests.size()));
        Attribute failureCount = new Attribute("failures", String.valueOf(failures));
        Attribute errorCount = new Attribute("errors", String.valueOf(errors));
        Attribute skippedCount = new Attribute("skipped", "0");
        Attribute time = new Attribute("time", NumberFormatter.stringValue(executionTime, 3));
        testsuite.setAttribute(name);
        testsuite.setAttribute(testCount);
        testsuite.setAttribute(failureCount);
        testsuite.setAttribute(errorCount);
        testsuite.setAttribute(skippedCount);
        testsuite.setAttribute(time);
        return testsuite;
    }
}

