/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import org.h2.api.IntervalQualifier;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.store.DataHandler;
import org.h2.util.Bits;
import org.h2.util.DateTimeUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueRow;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class Data {
    public static final int LENGTH_INT = 4;
    public static final int LENGTH_LONG = 8;
    private static final byte NULL = 0;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte INT = 4;
    private static final byte LONG = 5;
    private static final byte DECIMAL = 6;
    private static final byte DOUBLE = 7;
    private static final byte FLOAT = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte BYTES = 12;
    private static final byte STRING = 13;
    private static final byte STRING_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte RESULT_SET = 18;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte STRING_FIXED = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte LONG_0_7 = 48;
    private static final byte DECIMAL_0_1 = 56;
    private static final byte DECIMAL_SMALL_0 = 58;
    private static final byte DECIMAL_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte FLOAT_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte LONG_NEG = 67;
    private static final byte STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final int CUSTOM_DATA_TYPE = 135;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private byte[] data;
    private int pos;
    private final DataHandler handler;
    private final boolean storeLocalTime;

    private Data(DataHandler dataHandler, byte[] byArray, boolean bl) {
        this.handler = dataHandler;
        this.data = byArray;
        this.storeLocalTime = bl;
    }

    public void setInt(int n, int n2) {
        Bits.writeInt(this.data, n, n2);
    }

    public void writeInt(int n) {
        Bits.writeInt(this.data, this.pos, n);
        this.pos += 4;
    }

    public int readInt() {
        int n = Bits.readInt(this.data, this.pos);
        this.pos += 4;
        return n;
    }

    public static int getStringLen(String string) {
        int n = string.length();
        return Data.getStringWithoutLengthLen(string, n) + Data.getVarIntLen(n);
    }

    private static int getStringWithoutLengthLen(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0800') {
                n2 += 2;
                continue;
            }
            if (c < '\u0080') continue;
            ++n2;
        }
        return n + n2;
    }

    public String readString() {
        int n = this.readVarInt();
        return this.readString(n);
    }

    private String readString(int n) {
        byte[] byArray = this.data;
        int n2 = this.pos;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            cArray[i] = (n3 = byArray[n2++] & 0xFF) < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byArray[n2++] & 0x3F) << 6) + (byArray[n2++] & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byArray[n2++] & 0x3F)));
        }
        this.pos = n2;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n = string.length();
        this.writeVarInt(n);
        this.writeStringWithoutLength(string, n);
    }

    private void writeStringWithoutLength(String string, int n) {
        int n2 = this.pos;
        byte[] byArray = this.data;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(c >> 6 & 0x3F);
                byArray[n2++] = (byte)(c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(c & 0x3F);
        }
        this.pos = n2;
    }

    private void writeStringWithoutLength(char[] cArray, int n) {
        int n2 = this.pos;
        byte[] byArray = this.data;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(c >> 6 & 0x3F);
                byArray[n2++] = (byte)(c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(c & 0x3F);
        }
        this.pos = n2;
    }

    public static Data create(DataHandler dataHandler, int n, boolean bl) {
        return new Data(dataHandler, new byte[n], bl);
    }

    public static Data create(DataHandler dataHandler, byte[] byArray, boolean bl) {
        return new Data(dataHandler, byArray, bl);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        long l = Bits.readLong(this.data, this.pos);
        this.pos += 8;
        return l;
    }

    public void writeLong(long l) {
        Bits.writeLong(this.data, this.pos, l);
        this.pos += 8;
    }

    public void writeValue(Value value) {
        int n = this.pos;
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 0;
            return;
        }
        int n2 = value.getValueType();
        switch (n2) {
            case 1: {
                this.writeByte(value.getBoolean() ? (byte)65 : 64);
                break;
            }
            case 2: {
                this.writeByte((byte)2);
                this.writeByte(value.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)3);
                this.writeShortInt(value.getShort());
                break;
            }
            case 4: 
            case 25: {
                int n3 = value.getInt();
                if (n3 < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-n3);
                    break;
                }
                if (n3 < 16) {
                    this.writeByte((byte)(32 + n3));
                    break;
                }
                this.writeByte(n2 == 4 ? (byte)4 : 25);
                this.writeVarInt(n3);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-l);
                    break;
                }
                if (l < 8L) {
                    this.writeByte((byte)(48L + l));
                    break;
                }
                this.writeByte((byte)5);
                this.writeVarLong(l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    this.writeByte((byte)57);
                    break;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(bigInteger.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(n4);
                    this.writeVarLong(bigInteger.longValue());
                    break;
                }
                this.writeByte((byte)6);
                this.writeVarInt(n4);
                byte[] byArray = bigInteger.toByteArray();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                if (this.storeLocalTime) {
                    this.writeByte((byte)-124);
                    ValueTime valueTime = (ValueTime)value;
                    long l = valueTime.getNanos();
                    long l2 = l / 1000000L;
                    this.writeVarLong(l2);
                    this.writeVarLong(l -= l2 * 1000000L);
                    break;
                }
                this.writeByte((byte)9);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
                break;
            }
            case 10: {
                if (this.storeLocalTime) {
                    this.writeByte((byte)-123);
                    long l = ((ValueDate)value).getDateValue();
                    this.writeVarLong(l);
                    break;
                }
                this.writeByte((byte)10);
                long l = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                this.writeVarLong(l / 60000L);
                break;
            }
            case 11: {
                if (this.storeLocalTime) {
                    this.writeByte((byte)-122);
                    ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                    long l = valueTimestamp.getDateValue();
                    this.writeVarLong(l);
                    long l3 = valueTimestamp.getTimeNanos();
                    long l4 = l3 / 1000000L;
                    this.writeVarLong(l4);
                    this.writeVarLong(l3 -= l4 * 1000000L);
                    break;
                }
                Timestamp timestamp = value.getTimestamp();
                this.writeByte((byte)11);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(timestamp));
                this.writeVarInt(timestamp.getNanos() % 1000000);
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                this.writeByte((byte)24);
                this.writeVarLong(valueTimestampTimeZone.getDateValue());
                this.writeVarLong(valueTimestampTimeZone.getTimeNanos());
                this.writeVarInt(valueTimestampTimeZone.getTimeZoneOffsetMins());
                break;
            }
            case 19: 
            case 22: {
                this.writeByte(n2 == 22 ? (byte)22 : 19);
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                this.writeVarInt(n6);
                this.write(byArray, 0, n6);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n7 = byArray.length;
                if (n7 < 32) {
                    this.writeByte((byte)(100 + n7));
                    this.write(byArray, 0, n7);
                    break;
                }
                this.writeByte((byte)12);
                this.writeVarInt(n7);
                this.write(byArray, 0, n7);
                break;
            }
            case 20: {
                this.writeByte((byte)20);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n8 = string.length();
                if (n8 < 32) {
                    this.writeByte((byte)(68 + n8));
                    this.writeStringWithoutLength(string, n8);
                    break;
                }
                this.writeByte((byte)13);
                this.writeString(string);
                break;
            }
            case 14: {
                this.writeByte((byte)14);
                this.writeString(value.getString());
                break;
            }
            case 21: {
                this.writeByte((byte)21);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    this.writeByte((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == 0L) {
                    this.writeByte((byte)60);
                    break;
                }
                this.writeByte((byte)7);
                this.writeVarLong(Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    this.writeByte((byte)63);
                    break;
                }
                int n9 = Float.floatToIntBits(f);
                if (n9 == 0) {
                    this.writeByte((byte)62);
                    break;
                }
                this.writeByte((byte)8);
                this.writeVarInt(Integer.reverse(n9));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte(n2 == 15 ? (byte)15 : 16);
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n10 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n10 = -2;
                        }
                        this.writeVarInt(n10);
                        this.writeVarInt(valueLob.getTableId());
                        this.writeVarInt(valueLob.getObjectId());
                        this.writeVarLong(valueLob.getType().getPrecision());
                        this.writeByte((byte)(valueLob.isCompressed() ? 1 : 0));
                        if (n10 != -2) break;
                        this.writeString(valueLob.getFileName());
                        break;
                    }
                    this.writeVarInt(byArray.length);
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    this.writeVarInt(-3);
                    this.writeVarInt(valueLobDb.getTableId());
                    this.writeVarLong(valueLobDb.getLobId());
                    this.writeVarLong(valueLobDb.getType().getPrecision());
                    break;
                }
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: 
            case 39: {
                this.writeByte(n2 == 17 ? (byte)17 : 27);
                Value[] valueArray = ((ValueCollectionBase)value).getList();
                this.writeVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                this.writeByte((byte)18);
                ResultInterface resultInterface = ((ValueResultSet)value).getResult();
                resultInterface.reset();
                int n11 = resultInterface.getVisibleColumnCount();
                this.writeVarInt(n11);
                for (int i = 0; i < n11; ++i) {
                    this.writeString(resultInterface.getAlias(i));
                    this.writeString(resultInterface.getColumnName(i));
                    TypeInfo typeInfo = resultInterface.getColumnType(i);
                    this.writeVarInt(typeInfo.getValueType());
                    this.writeVarLong(typeInfo.getPrecision());
                    this.writeVarInt(typeInfo.getScale());
                }
                while (resultInterface.next()) {
                    this.writeByte((byte)1);
                    Value[] valueArray = resultInterface.currentRow();
                    for (int i = 0; i < n11; ++i) {
                        this.writeValue(valueArray[i]);
                    }
                }
                this.writeByte((byte)0);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n12 = n2 - 26;
                if (valueInterval.isNegative()) {
                    n12 ^= 0xFFFFFFFF;
                }
                this.writeByte((byte)26);
                this.writeByte((byte)n12);
                this.writeVarLong(valueInterval.getLeading());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                ValueInterval valueInterval = (ValueInterval)value;
                int n13 = n2 - 26;
                if (valueInterval.isNegative()) {
                    n13 ^= 0xFFFFFFFF;
                }
                this.writeByte((byte)26);
                this.writeByte((byte)n13);
                this.writeVarLong(valueInterval.getLeading());
                this.writeVarLong(valueInterval.getRemaining());
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    byte[] byArray = value.getBytesNoCopy();
                    this.writeByte((byte)-121);
                    this.writeVarInt(n2);
                    this.writeVarInt(byArray.length);
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                DbException.throwInternalError("type=" + value.getValueType());
            }
        }
        assert (this.pos - n == this.getValueLen(value)) : "value size error: got " + (this.pos - n) + " expected " + this.getValueLen(value);
    }

    public Value readValue() {
        int n = this.data[this.pos++] & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: 
            case 25: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int n2 = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), n2));
            }
            case 6: {
                int n3 = this.readVarInt();
                int n4 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n4);
                this.read(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 133: {
                return ValueDate.fromDateValue(this.readVarLong());
            }
            case 10: {
                long l = this.readVarLong() * 60000L;
                return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(l));
            }
            case 132: {
                long l = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTime.fromNanos(l);
            }
            case 9: {
                return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()));
            }
            case 134: {
                long l = this.readVarLong();
                long l2 = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 11: {
                return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()), this.readVarInt() % 1000000);
            }
            case 24: {
                long l = this.readVarLong();
                long l3 = this.readVarLong();
                short s = (short)this.readVarInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l3, s);
            }
            case 12: {
                int n5 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n5);
                this.read(byArray, 0, n5);
                return ValueBytes.getNoCopy(byArray);
            }
            case 22: {
                int n6 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n6);
                this.read(byArray, 0, n6);
                return ValueGeometry.get(byArray);
            }
            case 19: {
                int n7 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n7);
                this.read(byArray, 0, n7);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.ZERO;
            }
            case 63: {
                return ValueFloat.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int n8 = this.readVarInt();
                if (n8 >= 0) {
                    byte[] byArray = Utils.newBytes(n8);
                    this.read(byArray, 0, n8);
                    return ValueLobDb.createSmallLob(n == 15 ? 15 : 16, byArray);
                }
                if (n8 == -3) {
                    int n9 = this.readVarInt();
                    long l = this.readVarLong();
                    long l4 = this.readVarLong();
                    return ValueLobDb.create(n == 15 ? 15 : 16, this.handler, n9, l, null, l4);
                }
                int n10 = this.readVarInt();
                int n11 = this.readVarInt();
                long l = 0L;
                boolean bl = false;
                if (n8 == -1 || n8 == -2) {
                    l = this.readVarLong();
                    boolean bl2 = bl = this.readByte() == 1;
                }
                if (n8 == -2) {
                    String string = this.readString();
                    return ValueLob.openUnlinked(n == 15 ? 15 : 16, this.handler, n10, n11, l, bl, string);
                }
                return ValueLob.openLinked(n == 15 ? 15 : 16, this.handler, n10, n11, l, bl);
            }
            case 17: 
            case 27: {
                int n12 = this.readVarInt();
                Value[] valueArray = new Value[n12];
                for (int i = 0; i < n12; ++i) {
                    valueArray[i] = this.readValue();
                }
                return n == 17 ? ValueArray.get(valueArray) : ValueRow.get(valueArray);
            }
            case 18: {
                SimpleResult simpleResult = new SimpleResult();
                int n13 = this.readVarInt();
                for (int i = 0; i < n13; ++i) {
                    simpleResult.addColumn(this.readString(), this.readString(), this.readVarInt(), this.readVarLong(), this.readVarInt());
                }
                while (this.readByte() != 0) {
                    Value[] valueArray = new Value[n13];
                    for (int i = 0; i < n13; ++i) {
                        valueArray[i] = this.readValue();
                    }
                    simpleResult.addRow(valueArray);
                }
                return ValueResultSet.get(simpleResult);
            }
            case 26: {
                boolean bl;
                int n14 = this.readByte();
                boolean bl3 = bl = n14 < 0;
                if (bl) {
                    n14 ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(n14), bl, this.readVarLong(), n14 < 5 ? 0L : this.readVarLong());
            }
            case 135: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    int n15 = this.readVarInt();
                    int n16 = this.readVarInt();
                    byte[] byArray = Utils.newBytes(n16);
                    this.read(byArray, 0, n16);
                    return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(byArray), n15);
                }
                throw DbException.get(50004, "No CustomDataTypesHandler has been set up");
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n17 = n - 100;
            byte[] byArray = Utils.newBytes(n17);
            this.read(byArray, 0, n17);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(this.readString(n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    public int getValueLen(Value value) {
        return Data.getValueLen(value, this.storeLocalTime);
    }

    public static int getValueLen(Value value, boolean bl) {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getValueType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: 
            case 25: {
                int n = value.getInt();
                if (n < 0) {
                    return 1 + Data.getVarIntLen(-n);
                }
                if (n < 16) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(n);
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    return 1 + Data.getVarLongLen(-l);
                }
                if (l < 8L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(l);
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    return 1;
                }
                long l = Double.doubleToLongBits(d);
                if (l == 0L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(Long.reverse(l));
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    return 1;
                }
                int n = Float.floatToIntBits(f);
                if (n == 0) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(Integer.reverse(n));
            }
            case 13: {
                String string = value.getString();
                int n = string.length();
                if (n < 32) {
                    return 1 + Data.getStringWithoutLengthLen(string, n);
                }
                return 1 + Data.getStringLen(string);
            }
            case 14: 
            case 21: {
                return 1 + Data.getStringLen(value.getString());
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    return 1;
                }
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n2 = bigInteger.bitLength();
                if (n2 <= 63) {
                    if (n == 0) {
                        return 1 + Data.getVarLongLen(bigInteger.longValue());
                    }
                    return 1 + Data.getVarIntLen(n) + Data.getVarLongLen(bigInteger.longValue());
                }
                byte[] byArray = bigInteger.toByteArray();
                return 1 + Data.getVarIntLen(n) + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 9: {
                if (bl) {
                    long l = ((ValueTime)value).getNanos();
                    long l2 = l / 1000000L;
                    return 1 + Data.getVarLongLen(l2) + Data.getVarLongLen(l -= l2 * 1000000L);
                }
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
            }
            case 10: {
                if (bl) {
                    long l = ((ValueDate)value).getDateValue();
                    return 1 + Data.getVarLongLen(l);
                }
                long l = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                return 1 + Data.getVarLongLen(l / 60000L);
            }
            case 11: {
                if (bl) {
                    ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                    long l = valueTimestamp.getDateValue();
                    long l3 = valueTimestamp.getTimeNanos();
                    long l4 = l3 / 1000000L;
                    return 1 + Data.getVarLongLen(l) + Data.getVarLongLen(l4) + Data.getVarLongLen(l3 -= l4 * 1000000L);
                }
                Timestamp timestamp = value.getTimestamp();
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(timestamp)) + Data.getVarIntLen(timestamp.getNanos() % 1000000);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l = valueTimestampTimeZone.getDateValue();
                long l5 = valueTimestampTimeZone.getTimeNanos();
                short s = valueTimestampTimeZone.getTimeZoneOffsetMins();
                return 1 + Data.getVarLongLen(l) + Data.getVarLongLen(l5) + Data.getVarIntLen(s);
            }
            case 19: 
            case 22: {
                byte[] byArray = value.getBytesNoCopy();
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n = byArray.length;
                if (n < 32) {
                    return 1 + byArray.length;
                }
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int n = 1;
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n3 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n3 = -2;
                        }
                        n += Data.getVarIntLen(n3);
                        n += Data.getVarIntLen(valueLob.getTableId());
                        n += Data.getVarIntLen(valueLob.getObjectId());
                        n += Data.getVarLongLen(valueLob.getType().getPrecision());
                        ++n;
                        if (n3 == -2) {
                            n += Data.getStringLen(valueLob.getFileName());
                        }
                    } else {
                        n += Data.getVarIntLen(byArray.length);
                        n += byArray.length;
                    }
                } else {
                    ValueLobDb valueLobDb = (ValueLobDb)value;
                    byte[] byArray = valueLobDb.getSmall();
                    if (byArray == null) {
                        n += Data.getVarIntLen(-3);
                        n += Data.getVarIntLen(valueLobDb.getTableId());
                        n += Data.getVarLongLen(valueLobDb.getLobId());
                        n += Data.getVarLongLen(valueLobDb.getType().getPrecision());
                    } else {
                        n += Data.getVarIntLen(byArray.length);
                        n += byArray.length;
                    }
                }
                return n;
            }
            case 17: 
            case 39: {
                Value[] valueArray = ((ValueCollectionBase)value).getList();
                int n = 1 + Data.getVarIntLen(valueArray.length);
                for (Value value2 : valueArray) {
                    n += Data.getValueLen(value2, bl);
                }
                return n;
            }
            case 18: {
                int n = 1;
                ResultInterface resultInterface = ((ValueResultSet)value).getResult();
                int n4 = resultInterface.getVisibleColumnCount();
                n += Data.getVarIntLen(n4);
                for (int i = 0; i < n4; ++i) {
                    n += Data.getStringLen(resultInterface.getAlias(i));
                    n += Data.getStringLen(resultInterface.getColumnName(i));
                    TypeInfo typeInfo = resultInterface.getColumnType(i);
                    n += Data.getVarIntLen(typeInfo.getValueType());
                    n += Data.getVarLongLen(typeInfo.getPrecision());
                    n += Data.getVarIntLen(typeInfo.getScale());
                }
                while (resultInterface.next()) {
                    ++n;
                    Value[] valueArray = resultInterface.currentRow();
                    for (int i = 0; i < n4; ++i) {
                        Value value3 = valueArray[i];
                        n += Data.getValueLen(value3, bl);
                    }
                }
                return ++n;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                ValueInterval valueInterval = (ValueInterval)value;
                return 2 + Data.getVarLongLen(valueInterval.getLeading());
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                ValueInterval valueInterval = (ValueInterval)value;
                return 2 + Data.getVarLongLen(valueInterval.getLeading()) + Data.getVarLongLen(valueInterval.getRemaining());
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            byte[] byArray = value.getBytesNoCopy();
            return 1 + Data.getVarIntLen(value.getValueType()) + Data.getVarIntLen(byArray.length) + byArray.length;
        }
        throw DbException.throwInternalError("type=" + value.getValueType());
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void writeShortInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public short readShortInt() {
        byte[] byArray = this.data;
        return (short)(((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF));
    }

    public void truncate(int n) {
        if (this.pos > n) {
            byte[] byArray = Arrays.copyOf(this.data, n);
            this.pos = n;
            this.data = byArray;
        }
    }

    private static int getVarIntLen(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int n) {
        while ((n & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(n | 0x80);
            n >>>= 7;
        }
        this.data[this.pos++] = (byte)n;
    }

    public int readVarInt() {
        byte by = this.data[this.pos];
        if (by >= 0) {
            ++this.pos;
            return by;
        }
        return this.readVarIntRest(by);
    }

    private int readVarIntRest(int n) {
        int n2 = n & 0x7F;
        n = this.data[this.pos + 1];
        if (n >= 0) {
            this.pos += 2;
            return n2 | n << 7;
        }
        n2 |= (n & 0x7F) << 7;
        n = this.data[this.pos + 2];
        if (n >= 0) {
            this.pos += 3;
            return n2 | n << 14;
        }
        n2 |= (n & 0x7F) << 14;
        n = this.data[this.pos + 3];
        if (n >= 0) {
            this.pos += 4;
            return n2 | n << 21;
        }
        this.pos += 5;
        return n2 |= (n & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public static int getVarLongLen(long l) {
        int n = 1;
        while ((l >>>= 7) != 0L) {
            ++n;
        }
        return n;
    }

    public void writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(l | 0x80L);
            l >>>= 7;
        }
        this.data[this.pos++] = (byte)l;
    }

    public long readVarLong() {
        long l;
        if ((l = (long)this.data[this.pos++]) >= 0L) {
            return l;
        }
        l &= 0x7FL;
        int n = 7;
        while (true) {
            long l2 = this.data[this.pos++];
            l |= (l2 & 0x7FL) << n;
            if (l2 >= 0L) {
                return l;
            }
            n += 7;
        }
    }

    public void checkCapacity(int n) {
        if (this.pos + n >= this.data.length) {
            this.expand(n);
        }
    }

    private void expand(int n) {
        this.data = Utils.copyBytes(this.data, (this.data.length + n) * 2);
    }

    public void fillAligned() {
        int n;
        this.pos = n = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < n) {
            this.checkCapacity(n - this.data.length);
        }
    }

    public static void copyString(Reader reader, OutputStream outputStream) throws IOException {
        int n;
        char[] cArray = new char[4096];
        Data data = new Data(null, new byte[12288], false);
        while ((n = reader.read(cArray)) >= 0) {
            data.writeStringWithoutLength(cArray, n);
            outputStream.write(data.data, 0, data.pos);
            data.reset();
        }
    }

    public DataHandler getHandler() {
        return this.handler;
    }
}

