/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class CompareLike
extends Condition {
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private final CompareMode compareMode;
    private final String defaultEscape;
    private Expression left;
    private Expression right;
    private Expression escape;
    private boolean isInit;
    private char[] patternChars;
    private String patternString;
    private int[] patternTypes;
    private int patternLength;
    private final boolean regexp;
    private Pattern patternRegexp;
    private boolean ignoreCase;
    private boolean fastCompare;
    private boolean invalidPattern;

    public CompareLike(Database database, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this(database.getCompareMode(), database.getSettings().defaultEscape, expression, expression2, expression3, bl);
    }

    public CompareLike(CompareMode compareMode, String string, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.compareMode = compareMode;
        this.defaultEscape = string;
        this.regexp = bl;
        this.left = expression;
        this.right = expression2;
        this.escape = expression3;
    }

    private static Character getEscapeChar(String string) {
        return string == null || string.length() == 0 ? null : Character.valueOf(string.charAt(0));
    }

    @Override
    public String getSQL() {
        String string;
        if (this.regexp) {
            string = this.left.getSQL() + " REGEXP " + this.right.getSQL();
        } else {
            string = this.left.getSQL() + " LIKE " + this.right.getSQL();
            if (this.escape != null) {
                string = string + " ESCAPE " + this.escape.getSQL();
            }
        }
        return "(" + string + ")";
    }

    @Override
    public Expression optimize(Session session) {
        Value value;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.getType() == 14) {
            this.ignoreCase = true;
        }
        if (this.left.isValueSet() && (value = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        if (this.escape != null) {
            this.escape = this.escape.optimize(session);
        }
        if (this.right.isValueSet() && (this.escape == null || this.escape.isValueSet())) {
            Value value2;
            if (this.left.isValueSet()) {
                return ValueExpression.get(this.getValue(session));
            }
            value = this.right.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            String string = value.getString();
            this.initPattern(string, this.getEscapeChar(value2));
            if (this.invalidPattern) {
                return ValueExpression.getNull();
            }
            if ("%".equals(string)) {
                return new Comparison(session, 7, this.left, null).optimize(session);
            }
            if (this.isFullMatch()) {
                ValueString valueString = ValueString.get(this.patternString);
                ValueExpression valueExpression = ValueExpression.get(valueString);
                return new Comparison(session, 0, this.left, valueExpression).optimize(session);
            }
            this.isInit = true;
        }
        return this;
    }

    private Character getEscapeChar(Value value) {
        Character c;
        if (value == null) {
            return CompareLike.getEscapeChar(this.defaultEscape);
        }
        String string = value.getString();
        if (string == null) {
            c = CompareLike.getEscapeChar(this.defaultEscape);
        } else if (string.length() == 0) {
            c = null;
        } else {
            if (string.length() > 1) {
                throw DbException.get(22025, string);
            }
            c = Character.valueOf(string.charAt(0));
        }
        return c;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        Value value;
        if (this.regexp) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (!this.right.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        if (this.escape != null && !this.escape.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        String string = this.right.getValue(session).getString();
        Value value2 = value = this.escape == null ? null : this.escape.getValue(session);
        if (value == ValueNull.INSTANCE) {
            DbException.throwInternalError();
        }
        this.initPattern(string, this.getEscapeChar(value));
        if (this.invalidPattern) {
            return;
        }
        if (this.patternLength <= 0 || this.patternTypes[0] != 0) {
            return;
        }
        int n = expressionColumn.getColumn().getType();
        if (n != 13 && n != 14 && n != 21) {
            return;
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < this.patternLength && this.patternTypes[n2] == 0) {
            stringBuilder.append(this.patternChars[n2++]);
        }
        String string2 = stringBuilder.toString();
        if (n2 == this.patternLength) {
            tableFilter.addIndexCondition(IndexCondition.get(0, expressionColumn, ValueExpression.get(ValueString.get(string2))));
        } else if (string2.length() > 0) {
            tableFilter.addIndexCondition(IndexCondition.get(1, expressionColumn, ValueExpression.get(ValueString.get(string2))));
            char c = string2.charAt(string2.length() - 1);
            for (int i = 1; i < 2000; ++i) {
                String string3 = string2.substring(0, string2.length() - 1) + (char)(c + i);
                if (this.compareMode.compareString(string2, string3, this.ignoreCase) != -1) continue;
                tableFilter.addIndexCondition(IndexCondition.get(4, expressionColumn, ValueExpression.get(ValueString.get(string3))));
                break;
            }
        }
    }

    @Override
    public Value getValue(Session session) {
        Object object;
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (!this.isInit) {
            Value value2;
            object = this.right.getValue(session);
            if (object == ValueNull.INSTANCE) {
                return object;
            }
            String string = ((Value)object).getString();
            Value value3 = value2 = this.escape == null ? null : this.escape.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.initPattern(string, this.getEscapeChar(value2));
        }
        if (this.invalidPattern) {
            return ValueNull.INSTANCE;
        }
        object = value.getString();
        boolean bl = this.regexp ? this.patternRegexp.matcher((CharSequence)object).find() : this.compareAt((String)object, 0, 0, ((String)object).length(), this.patternChars, this.patternTypes);
        return ValueBoolean.get(bl);
    }

    private boolean compare(char[] cArray, String string, int n, int n2) {
        return cArray[n] == string.charAt(n2) || !this.fastCompare && this.compareMode.equalsChars(this.patternString, n, string, n2, this.ignoreCase);
    }

    private boolean compareAt(String string, int n, int n2, int n3, char[] cArray, int[] nArray) {
        while (n < this.patternLength) {
            switch (nArray[n]) {
                case 0: {
                    if (n2 < n3 && this.compare(cArray, string, n, n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n3) break;
                    return false;
                }
                case 2: {
                    if (++n >= this.patternLength) {
                        return true;
                    }
                    while (n2 < n3) {
                        if (this.compare(cArray, string, n, n2) && this.compareAt(string, n, n2, n3, cArray, nArray)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                default: {
                    DbException.throwInternalError();
                }
            }
            ++n;
        }
        return n2 == n3;
    }

    public boolean test(String string, String string2, char c) {
        this.initPattern(string, Character.valueOf(c));
        if (this.invalidPattern) {
            return false;
        }
        return this.compareAt(string2, 0, 0, string2.length(), this.patternChars, this.patternTypes);
    }

    private void initPattern(String string, Character c) {
        int n;
        if (this.compareMode.getName().equals("OFF") && !this.ignoreCase) {
            this.fastCompare = true;
        }
        if (this.regexp) {
            this.patternString = string;
            try {
                this.patternRegexp = this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DbException.get(22025, patternSyntaxException, string);
            }
            return;
        }
        this.patternLength = 0;
        if (string == null) {
            this.patternTypes = null;
            this.patternChars = null;
            return;
        }
        int n2 = string.length();
        this.patternChars = new char[n2];
        this.patternTypes = new int[n2];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            int n3;
            char c2 = string.charAt(n);
            if (c != null && c.charValue() == c2) {
                if (n >= n2 - 1) {
                    this.invalidPattern = true;
                    return;
                }
                c2 = string.charAt(++n);
                n3 = 0;
                bl = false;
            } else if (c2 == '%') {
                if (bl) continue;
                n3 = 2;
                bl = true;
            } else if (c2 == '_') {
                n3 = 1;
            } else {
                n3 = 0;
                bl = false;
            }
            this.patternTypes[this.patternLength] = n3;
            this.patternChars[this.patternLength++] = c2;
        }
        for (n = 0; n < this.patternLength - 1; ++n) {
            if (this.patternTypes[n] != 2 || this.patternTypes[n + 1] != 1) continue;
            this.patternTypes[n] = 1;
            this.patternTypes[n + 1] = 2;
        }
        this.patternString = new String(this.patternChars, 0, this.patternLength);
    }

    private boolean isFullMatch() {
        if (this.patternTypes == null) {
            return false;
        }
        for (int n : this.patternTypes) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
        if (this.escape != null) {
            this.escape.mapColumns(columnResolver, n);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
        if (this.escape != null) {
            this.escape.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
        if (this.escape != null) {
            this.escape.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor) && (this.escape == null || this.escape.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 3;
    }
}

