/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.util;

import java.util.HashSet;
import java.util.Set;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Objects {
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final String ARRAY_END = "}";
    private static final String ARRAY_START = "{";
    private static final String EMPTY_ARRAY = "{}";
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String NULL_ARRAY = "null";
    private static final Set primitivesAndWrappers = new HashSet();

    static {
        primitivesAndWrappers.add(Boolean.TYPE);
        primitivesAndWrappers.add(Boolean.class);
        primitivesAndWrappers.add(Byte.TYPE);
        primitivesAndWrappers.add(Byte.class);
        primitivesAndWrappers.add(Character.TYPE);
        primitivesAndWrappers.add(Character.class);
        primitivesAndWrappers.add(Double.TYPE);
        primitivesAndWrappers.add(Double.class);
        primitivesAndWrappers.add(Float.TYPE);
        primitivesAndWrappers.add(Float.class);
        primitivesAndWrappers.add(Integer.TYPE);
        primitivesAndWrappers.add(Integer.class);
        primitivesAndWrappers.add(Long.TYPE);
        primitivesAndWrappers.add(Long.class);
        primitivesAndWrappers.add(Short.TYPE);
        primitivesAndWrappers.add(Short.class);
    }

    public static int hashCode(boolean bool) {
        return bool ? 1231 : 1237;
    }

    public static int hashCode(double dbl) {
        long bits = Double.doubleToLongBits(dbl);
        return Objects.hashCode(bits);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }

    public static StringBuffer identityToString(Object obj) {
        StringBuffer buffer = new StringBuffer();
        if (obj != null) {
            buffer.append(obj.getClass().getName());
            buffer.append("@");
            buffer.append(ObjectUtils.getIdentityHexString((Object)obj));
        }
        return buffer;
    }

    public static boolean isArrayOfPrimitives(Object array) {
        boolean primitiveArray = false;
        if (array != null) {
            Class<?> clazz = array.getClass();
            primitiveArray = clazz.isArray() && clazz.getComponentType().isPrimitive();
        }
        return primitiveArray;
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        return primitivesAndWrappers.contains(clazz);
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + Objects.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + array[i];
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + array[i];
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + Objects.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + Objects.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + array[i];
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + Objects.hashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof boolean[]) {
            return Objects.nullSafeHashCode((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Objects.nullSafeHashCode((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Objects.nullSafeHashCode((char[])obj);
        }
        if (obj instanceof double[]) {
            return Objects.nullSafeHashCode((double[])obj);
        }
        if (obj instanceof float[]) {
            return Objects.nullSafeHashCode((float[])obj);
        }
        if (obj instanceof int[]) {
            return Objects.nullSafeHashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return Objects.nullSafeHashCode((long[])obj);
        }
        if (obj instanceof short[]) {
            return Objects.nullSafeHashCode((short[])obj);
        }
        if (obj instanceof Object[]) {
            return Objects.nullSafeHashCode((Object[])obj);
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + Objects.nullSafeHashCode(array[i]);
            ++i;
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        int i = 0;
        while (i < arraySize) {
            hash = 31 * hash + array[i];
            ++i;
        }
        return hash;
    }

    public static String nullSafeToString(boolean[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(byte[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(char[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append("'" + array[i] + "'");
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(double[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(float[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(int[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(long[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(Object[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(StringUtils.quoteIfString((Object)array[i]));
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(short[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(String[] array) {
        if (array == null) {
            return NULL_ARRAY;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(StringUtils.quote((String)array[i]));
            ++i;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }
}

