/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.util;

import com.dmx.cache.base.CacheEntry;
import com.dmx.cache.caching.CacheAdministrator;
import com.dmx.cache.key.CacheKeyGenerator;
import com.dmx.cache.key.ReflectionCodeCacheKeyGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class CachingUtil {
    protected static final transient Logger log = Logger.getLogger(CachingUtil.class);
    private Properties cacheAttributes;
    private CacheKeyGenerator cacheKey = new ReflectionCodeCacheKeyGenerator();
    private int expiry = 0;

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public Properties getCacheAttributes() {
        return this.cacheAttributes;
    }

    public void setCacheAttributes(Properties cacheAttributes) {
        this.cacheAttributes = cacheAttributes;
    }

    public String getCacheMethodAttributes(MethodInvocation invocation) {
        Object o = this.cacheAttributes.get(invocation.getMethod().getName());
        if (o != null) {
            return (String)o;
        }
        Enumeration<?> e = this.cacheAttributes.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!(key.indexOf("*") == 0 ? invocation.getMethod().getName().indexOf(key.replace("*", "")) == invocation.getMethod().getName().length() - 1 : (key.indexOf("*") == key.length() - 1 ? invocation.getMethod().getName().indexOf(key.replace("*", "")) == 0 : "*".equals(key)))) continue;
            return this.cacheAttributes.getProperty(key);
        }
        return "";
    }

    public String getCacheKey(MethodInvocation invocation) {
        String name = invocation.getMethod().getGenericReturnType().toString();
        return String.valueOf(this.getGroupKeyByMethod(invocation)) + this.cacheKey.generateKey(invocation);
    }

    public String getCacheGroupKey(MethodInvocation invocation) {
        return this.getGroupKeyByMethod(invocation);
    }

    private String getGroupKeyByMethod(MethodInvocation invocation) {
        return this.formatKey(invocation.getMethod().toString(), invocation.getMethod().getName());
    }

    private String formatKey(String key, String rename) {
        try {
            if (key != null && !"".equals(key)) {
                key = key.substring(key.lastIndexOf(" "), key.length());
                key = key.substring(0, key.indexOf(rename));
                key = key.substring(0, key.lastIndexOf("."));
                key = key.substring(key.lastIndexOf(".") + 1, key.length());
            }
        }
        catch (Exception e) {
            log.error((Object)"[formatKey]", (Throwable)e);
        }
        return key;
    }

    public Hashtable getWasFlushed(boolean wasFlushed, CacheEntry cacheEntry, CacheAdministrator cacheAdministrator) {
        boolean flushed = wasFlushed;
        Hashtable<String, Boolean> flushedH = new Hashtable<String, Boolean>();
        boolean flush = false;
        if (!wasFlushed && cacheEntry != null) {
            Hashtable groups = cacheAdministrator.getEntryGroup().getRefurbishGroups(cacheEntry.getGroups());
            if (groups != null && !groups.isEmpty() && groups.get(cacheEntry.getKey()) != null && groups.get("created") != null) {
                long groupsCreated = (Long)groups.get("created");
                if (cacheEntry.getCreated() <= groupsCreated) {
                    flushed = true;
                    flush = true;
                } else {
                    cacheAdministrator.getEntryGroup().removeRefurbishGroupsByKey(cacheEntry.getKey(), cacheEntry.getGroups());
                }
            }
        } else if (cacheEntry == null) {
            flushed = true;
        }
        flushedH.put("flushed", flushed);
        flushedH.put("flush", flush);
        return flushedH;
    }

    public static String getHostName() {
        String host = "";
        try {
            InetAddress canonicalHostName = InetAddress.getLocalHost();
            host = canonicalHostName.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)"[HostName]", (Throwable)e);
        }
        return host;
    }
}

