/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.key;

import com.dmx.cache.key.CacheKeyGenerator;
import com.dmx.cache.key.HashCodeCacheKey;
import com.dmx.cache.key.HashCodeCalculator;
import com.dmx.cache.util.Objects;
import com.dmx.cache.util.Reflections;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class HashCodeCacheKeyGenerator
implements CacheKeyGenerator {
    private boolean generateArgumentHashCode = true;

    public HashCodeCacheKeyGenerator() {
    }

    public HashCodeCacheKeyGenerator(boolean generateArgumentHashCode) {
        this();
        this.setGenerateArgumentHashCode(generateArgumentHashCode);
    }

    @Override
    public final Serializable generateKey(MethodInvocation methodInvocation) {
        HashCodeCalculator hashCodeCalculator = new HashCodeCalculator();
        Method method = methodInvocation.getMethod();
        hashCodeCalculator.append(System.identityHashCode(method));
        Object[] methodArguments = methodInvocation.getArguments();
        if (methodArguments != null) {
            int methodArgumentCount = methodArguments.length;
            int i = 0;
            while (i < methodArgumentCount) {
                Object methodArgument = methodArguments[i];
                int hash = 0;
                hash = this.generateArgumentHashCode ? Reflections.reflectionHashCode(methodArgument) : Objects.nullSafeHashCode(methodArgument);
                hashCodeCalculator.append(hash);
                ++i;
            }
        }
        long checkSum = hashCodeCalculator.getCheckSum();
        int hashCode = hashCodeCalculator.getHashCode();
        HashCodeCacheKey cacheKey = new HashCodeCacheKey(checkSum, hashCode);
        return cacheKey;
    }

    public final void setGenerateArgumentHashCode(boolean newGenerateArgumentHashCode) {
        this.generateArgumentHashCode = newGenerateArgumentHashCode;
    }
}

