/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.interceptor;

import com.dmx.cache.base.CacheEntry;
import com.dmx.cache.caching.CacheAdministrator;
import com.dmx.cache.feed.FeedHandle;
import com.dmx.cache.util.CachingUtil;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class CacheInterceptor
implements MethodInterceptor,
Serializable {
    protected final transient Logger log = Logger.getLogger(CacheInterceptor.class);
    private static final long serialVersionUID = 3734129542350451759L;
    private final CachingUtil cachingUtil = new CachingUtil();
    private CacheAdministrator cacheAdministrator;
    private FeedHandle feedHandle;

    public void setCacheAttributes(Properties cacheAttributes) {
        this.cachingUtil.setCacheAttributes(cacheAttributes);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        String methodAttributes = this.cachingUtil.getCacheMethodAttributes(invocation);
        this.log.debug((Object)("invoke " + invocation.getMethod() + " methodAttributes:" + methodAttributes));
        result = methodAttributes != null && !"".equals(methodAttributes) ? this.getResult(invocation, methodAttributes) : invocation.proceed();
        return result;
    }

    private Object getResult(MethodInvocation invocation, String methodAttributes) throws Throwable {
        Object result = null;
        String[] arry = methodAttributes.split("=");
        if (arry != null) {
            int expiry = 0;
            if (arry.length >= 2 && arry[1] != null && !"".equals(arry[1])) {
                expiry = Integer.parseInt(arry[1]);
            }
            String[] stat = arry[0].split("_");
            String infoState = "";
            if (stat.length >= 2 && stat[1] != null && !"".equals(stat[1])) {
                infoState = stat[1];
            }
            if ("UPDATE".equals(stat[0])) {
                this.log.debug((Object)"invoke  removeCacheGrouped ");
                result = this.getResultCache(invocation, expiry, true, infoState);
            } else if ("NOCACHE".equals(stat[0])) {
                this.log.debug((Object)"invoke  nocahe CacheGrouped ");
                result = invocation.proceed();
                this.noCacheInfo(invocation, expiry, infoState);
            } else {
                this.log.debug((Object)"invoke  readOnly CacheGrouped ");
                result = this.getResultCache(invocation, expiry, false, infoState);
            }
        }
        return result;
    }

    private Object getResultCache(MethodInvocation invocation, int expiry, boolean wasFlushed, String infoState) throws Throwable {
        Object result = null;
        String key = this.cachingUtil.getCacheKey(invocation);
        this.log.debug((Object)("invoke getResultCache key=" + key));
        if (key != null && !"".equals(key)) {
            CacheEntry cacheEntry = this.cacheAdministrator.getCache(key);
            Hashtable flushedH = this.cachingUtil.getWasFlushed(wasFlushed, cacheEntry, this.cacheAdministrator);
            boolean flushed = wasFlushed;
            boolean flush = false;
            if (flushedH != null) {
                flushed = (Boolean)flushedH.get("flushed");
                flush = (Boolean)flushedH.get("flush");
            }
            if (flushedH != null && !flushed) {
                result = cacheEntry.getContent();
                this.log.debug((Object)"invoke getResultCache cached");
            } else {
                try {
                    result = invocation.proceed();
                    if (result != null) {
                        cacheEntry = this.cacheAdministrator.putCache(key, this.cachingUtil.getCacheGroupKey(invocation), result, expiry);
                    }
                    if (flushed && wasFlushed) {
                        this.cacheAdministrator.updateEntryGroup(key, this.cachingUtil.getCacheGroupKey(invocation), true);
                        this.info(infoState, cacheEntry, "INFOANNOUNCE");
                    } else if (flush) {
                        this.cacheAdministrator.removeRefurbishGroupsByKey(key, this.cachingUtil.getCacheGroupKey(invocation));
                        this.info(infoState, cacheEntry, "INFOUPDATE");
                    } else {
                        this.info(infoState, cacheEntry, "INFOEXPIRY");
                    }
                }
                catch (Throwable e) {
                    this.log.error((Object)"[cache invocation.proceed()]", e);
                    result = cacheEntry.getContent();
                }
                this.log.debug((Object)"invoke getResultCache proceed");
            }
        } else {
            result = invocation.proceed();
            this.log.debug((Object)"invoke  proceed");
        }
        return result;
    }

    private void noCacheInfo(MethodInvocation invocation, int expiry, String infoState) {
        if (infoState == null || "".equals(infoState)) {
            return;
        }
        CacheEntry cacheEntry = new CacheEntry(this.cachingUtil.getCacheKey(invocation), this.cachingUtil.getCacheGroupKey(invocation), null, expiry);
        this.info(infoState, cacheEntry, "INFOANNOUNCE");
    }

    private void info(String infoState, CacheEntry cacheEntry, String dealInfo) {
        if (this.feedHandle != null) {
            this.feedHandle.handle(infoState, cacheEntry, dealInfo);
        }
    }

    public CacheAdministrator getCacheAdministrator() {
        return this.cacheAdministrator;
    }

    public void setCacheAdministrator(CacheAdministrator cacheAdministrator) {
        this.cacheAdministrator = cacheAdministrator;
    }

    public FeedHandle getFeedHandle() {
        return this.feedHandle;
    }

    public void setFeedHandle(FeedHandle feedHandle) {
        this.feedHandle = feedHandle;
    }
}

