/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.feed;

import com.dmx.cache.feed.CacheMessageDTO;
import com.dmx.cache.feed.MessageHandle;
import com.dmx.cache.util.CachingUtil;
import com.ftness.feed.jms.Message;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MessageReceive {
    protected final transient Logger log = Logger.getLogger(MessageReceive.class);
    private MessageHandle messageHandle;
    ExecutorService exec = Executors.newFixedThreadPool(20);

    public void receive(Message message) {
        this.log.info((Object)("receive message start " + Thread.currentThread().getName()));
        if (message == null || message.getObject() == null || !(message.getObject() instanceof CacheMessageDTO)) {
            return;
        }
        Object o = message.getObject();
        final CacheMessageDTO cacheMessageDTO = (CacheMessageDTO)o;
        this.log.info((Object)("receive message id:" + message.getId() + " name:" + message.getName() + " Version:" + message.getVersion() + " hostname:" + cacheMessageDTO.getHostName()));
        if (cacheMessageDTO == null || CachingUtil.getHostName().equals(cacheMessageDTO.getHostName())) {
            return;
        }
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                MessageReceive.this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " hostname:" + cacheMessageDTO.getHostName() + " State:" + cacheMessageDTO.getState()));
                MessageReceive.this.messageHandle.handle(cacheMessageDTO);
            }
        });
    }

    public MessageHandle getMessageHandle() {
        return this.messageHandle;
    }

    public void setMessageHandle(MessageHandle messageHandle) {
        this.messageHandle = messageHandle;
    }
}

