/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.feed;

import com.dmx.cache.base.CacheEntry;
import com.dmx.cache.caching.CacheAdministrator;
import com.dmx.cache.feed.CacheMessageDTO;
import org.apache.log4j.Logger;

public class MessageHandle {
    protected final transient Logger log = Logger.getLogger(MessageHandle.class);
    private CacheAdministrator cacheAdministrator;

    public CacheAdministrator getCacheAdministrator() {
        return this.cacheAdministrator;
    }

    public void setCacheAdministrator(CacheAdministrator cacheAdministrator) {
        this.cacheAdministrator = cacheAdministrator;
    }

    public void handle(CacheMessageDTO cacheMessageDTO) {
        if (cacheMessageDTO == null) {
            return;
        }
        this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " hostname:" + cacheMessageDTO.getHostName() + " State:" + cacheMessageDTO.getState()));
        boolean deal = false;
        if ("INFOUPDATE".equals(cacheMessageDTO.getState())) {
            if (cacheMessageDTO.getObject() != null && cacheMessageDTO.getObject() instanceof CacheEntry) {
                if (((CacheEntry)cacheMessageDTO.getObject()).getContent() != null && !"".equals(((CacheEntry)cacheMessageDTO.getObject()).getContent())) {
                    this.cacheAdministrator.putCache((CacheEntry)cacheMessageDTO.getObject());
                } else {
                    this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " INFOUPDATE CacheEntry.getContent() is null to INFOEXPIRY"));
                    this.cacheAdministrator.putRefurbishGroupsByKey((CacheEntry)cacheMessageDTO.getObject());
                }
                deal = true;
            } else {
                this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " INFOUPDATE CacheEntry is null"));
            }
        } else if ("INFOEXPIRY".equals(cacheMessageDTO.getState())) {
            if (cacheMessageDTO.getObject() != null && cacheMessageDTO.getObject() instanceof CacheEntry) {
                this.cacheAdministrator.putRefurbishGroupsByKey((CacheEntry)cacheMessageDTO.getObject());
                deal = true;
            } else {
                this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " INFOEXPIRY CacheEntry is null"));
            }
        } else if ("INFOANNOUNCE".equals(cacheMessageDTO.getState())) {
            if (cacheMessageDTO.getObject() != null && cacheMessageDTO.getObject() instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)cacheMessageDTO.getObject();
                if (cacheEntry.getContent() != null && !"".equals(cacheEntry.getContent())) {
                    this.cacheAdministrator.putCache(cacheEntry);
                }
                this.cacheAdministrator.updateEntryGroup(cacheEntry.getKey(), cacheEntry.getGroups(), true);
                deal = true;
            } else {
                this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " INFOANNOUNCE  CacheEntry is null"));
            }
        }
        this.log.info((Object)("Thread:" + Thread.currentThread().getName() + " hostname:" + cacheMessageDTO.getHostName() + " State:" + cacheMessageDTO.getState() + " deal:" + deal));
    }
}

