/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.feed;

import com.dmx.cache.base.CacheEntry;
import com.dmx.cache.feed.CacheMessageDTO;
import com.dmx.cache.feed.MessageSend;
import com.dmx.cache.util.CachingUtil;
import org.apache.log4j.Logger;

public class FeedHandle {
    protected final transient Logger log = Logger.getLogger(FeedHandle.class);
    private MessageSend messageSend;

    public MessageSend getMessageSend() {
        return this.messageSend;
    }

    public void setMessageSend(MessageSend messageSend) {
        this.messageSend = messageSend;
    }

    public void handle(String infoState, CacheEntry cacheEntry, String dealInfo) {
        if (infoState == null || "".equals(infoState)) {
            return;
        }
        if (cacheEntry != null) {
            this.log.info((Object)("cacheEntry  info start infoState:" + infoState + " cacheEntry key:" + cacheEntry.getKey() + " Groupskey:" + cacheEntry.getGroups() + " dealInfo:" + dealInfo));
        } else {
            this.log.info((Object)("cacheEntry is null info start infoState:" + infoState + " dealInfo:" + dealInfo));
        }
        try {
            boolean state = false;
            CacheMessageDTO messageDTO = new CacheMessageDTO();
            if ("INFOAUTOMATED".equals(infoState) && dealInfo != null && !"".endsWith(dealInfo)) {
                infoState = dealInfo;
            }
            if ("INFOUPDATE".equals(infoState)) {
                messageDTO.setObject(cacheEntry);
                messageDTO.setState("INFOUPDATE");
                state = true;
            } else if ("INFOEXPIRY".equals(infoState)) {
                messageDTO.setState("INFOEXPIRY");
                if (cacheEntry != null) {
                    cacheEntry.setContent(null);
                }
                messageDTO.setObject(cacheEntry);
                state = true;
            } else if ("INFOANNOUNCE".equals(infoState)) {
                messageDTO.setState("INFOANNOUNCE");
                messageDTO.setObject(cacheEntry);
                state = true;
            }
            if (state) {
                messageDTO.setCread(System.currentTimeMillis());
                messageDTO.setHostName(CachingUtil.getHostName());
                this.messageSend.sendMessage(messageDTO);
                this.log.info((Object)("cacheEntry  info success infoState:" + infoState));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"[info handle ]", (Throwable)e);
        }
    }
}

