/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.caching.impl;

import com.dmx.cache.caching.CachingClient;
import com.dmx.cache.util.MD5;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.log4j.Logger;

public class CachingXMemcachedClient
implements CachingClient {
    protected final transient Logger log = Logger.getLogger(CachingXMemcachedClient.class);
    private MemcachedClient memcachedClient;
    private boolean isflushAll = false;
    private long timeout = 5000L;
    private Integer compressionThreshold = 1024;

    public boolean isIsflushAll() {
        return this.isflushAll;
    }

    public void setIsflushAll(boolean isflushAll) {
        this.isflushAll = isflushAll;
    }

    public void init() {
        if (this.isflushAll) {
            this.clear();
        }
        this.memcachedClient.setOpTimeout(this.timeout);
        this.log.info((Object)("[Caching inited] isflushAll:" + this.isflushAll + " timeout:" + this.timeout));
    }

    @Override
    public boolean clear() {
        try {
            this.memcachedClient.flushAll();
            return true;
        }
        catch (TimeoutException e) {
            this.log.error((Object)"[clear]", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"[clear]", (Throwable)e);
        }
        catch (MemcachedException e) {
            this.log.error((Object)"[clear]", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        return true;
    }

    @Override
    public void destroy() {
        try {
            this.log.info((Object)"[Caching destroy]");
            this.memcachedClient.shutdown();
        }
        catch (IOException e) {
            this.log.error((Object)"[destroy]", (Throwable)e);
        }
    }

    @Override
    public Object get(String key) {
        if (this.memcachedClient != null && key != null && !key.equals("")) {
            Object obj = null;
            try {
                key = key.toLowerCase();
                if (key.getBytes().length > 200) {
                    key = new MD5().compute(key);
                }
                obj = this.memcachedClient.get(key);
            }
            catch (TimeoutException e) {
                this.log.error((Object)"[get]", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error((Object)"[get]", (Throwable)e);
            }
            catch (MemcachedException e) {
                this.log.error((Object)"[get]", (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("[get] key=" + key), e);
            }
            return obj;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        this.put(key, value, 0);
        return value;
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        return this.put(key, value, this.getExpiry(expiry));
    }

    @Override
    public Object put(String key, Object value, int expiry) {
        if (this.memcachedClient != null && value != null && key != null && !key.equals("")) {
            try {
                key = key.toLowerCase();
                if (key.getBytes().length > 200) {
                    key = new MD5().compute(key);
                }
                this.memcachedClient.set(key, expiry, value);
            }
            catch (TimeoutException e) {
                this.log.error((Object)"[put]", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error((Object)"[put]", (Throwable)e);
            }
            catch (MemcachedException e) {
                this.log.error((Object)("[put] key=" + key), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public Object remove(String key) {
        if (this.memcachedClient != null && key != null && !key.equals("")) {
            Object obj = null;
            try {
                key = key.toLowerCase();
                if (key.getBytes().length > 200) {
                    key = new MD5().compute(key);
                }
                obj = this.memcachedClient.get(key);
                this.memcachedClient.delete(key);
            }
            catch (TimeoutException e) {
                this.log.error((Object)"[remove]", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error((Object)"[remove]", (Throwable)e);
            }
            catch (MemcachedException e) {
                this.log.error((Object)"[remove]", (Throwable)e);
            }
            return obj;
        }
        return null;
    }

    private int getExpiry(Date expiry) {
        long diffHours;
        Calendar cal1;
        if (expiry == null) {
            return 0;
        }
        Calendar cal2 = cal1 = Calendar.getInstance();
        cal2.setTime(expiry);
        long milis1 = cal1.getTimeInMillis();
        long milis2 = cal2.getTimeInMillis();
        long diff = milis2 - milis1;
        if (milis2 <= milis1) {
            diff = milis1 - milis2;
        }
        if ((diffHours = diff / 3600000L) <= 0L) {
            diffHours = 24L;
        }
        int expiryIn = 3600;
        return expiryIn * (int)diffHours;
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

