/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.caching.impl;

import com.dmx.cache.base.CacheEntry;
import com.dmx.cache.base.EntryGroup;
import com.dmx.cache.caching.CacheAdministrator;
import com.dmx.cache.caching.CachingClient;
import com.dmx.cache.util.CachingUtil;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CacheAdministratorImpl
implements CacheAdministrator {
    protected final transient Logger log = Logger.getLogger(CacheAdministratorImpl.class);
    private long entryGroupUpdate = -1L;
    public CachingClient cachingClient;
    public EntryGroup entryGroup;

    @Override
    public Object get(String key) {
        return this.cachingClient.get(key);
    }

    @Override
    public Object remove(String key) {
        Object o = this.cachingClient.remove(key);
        if (o != null && o instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)o;
            this.entryGroup.getEntryGroup(cacheEntry.getGroups()).remove(key);
            return cacheEntry.getContent();
        }
        this.entryGroup.remove(key);
        this.dealEntryGroupToCache();
        return o;
    }

    @Override
    public Object put(String key, Object value, int expiry) {
        return this.put(key, null, value, expiry);
    }

    @Override
    public Object put(String key, String groupkey, Object value, int expiry) {
        this.entryGroup.setEntryGroup(key, groupkey);
        this.dealEntryGroupToCache();
        return this.cachingClient.put(key, value, expiry);
    }

    @Override
    public synchronized boolean removeCacheGroup(String key) {
        Object o = this.cachingClient.remove(key);
        String groupskey = key;
        if (o != null && o instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)o;
            groupskey = cacheEntry.getGroups();
        }
        Hashtable groupMap = this.entryGroup.getEntryGroup(groupskey);
        for (String rekey : groupMap.keySet()) {
            this.log.debug((Object)("[removeCacheGroup] rekey=" + rekey));
            this.cachingClient.remove(rekey);
        }
        this.entryGroup.remove(groupskey);
        this.dealEntryGroupToCache();
        return true;
    }

    @Override
    public EntryGroup getEntryGroup() {
        return this.entryGroup;
    }

    public void setEntryGroup(EntryGroup entryGroup) {
        this.entryGroup = entryGroup;
    }

    @Override
    public CacheEntry getCache(String key) {
        Object o = this.cachingClient.get(key);
        if (o != null && o instanceof CacheEntry) {
            return (CacheEntry)o;
        }
        return null;
    }

    @Override
    public CacheEntry putCache(String key, String groupkey, Object value, int expiry) {
        CacheEntry cacheEntry = new CacheEntry(key, groupkey, value, expiry);
        this.cachingClient.put(key, (Object)cacheEntry, expiry);
        this.entryGroup.setEntryGroup(key, groupkey);
        this.dealEntryGroupToCache();
        return cacheEntry;
    }

    public void init() {
        Object o = this.cachingClient.get("CacheAdministrator-EntryGroup-" + CachingUtil.getHostName());
        if (o != null) {
            this.entryGroup = (EntryGroup)o;
            this.log.info((Object)"CacheAdministrator get EntryGroup Cached");
        }
        if (this.entryGroup == null) {
            this.entryGroup = new EntryGroup();
        }
    }

    public void destroy() {
        this.putEntryGroupToCache();
    }

    public void dealEntryGroupToCache() {
        if (this.entryGroupUpdate == -1L || this.entryGroupUpdate >= 0L && System.currentTimeMillis() >= this.entryGroupUpdate + 60000L) {
            this.putEntryGroupToCache();
        }
    }

    private void putEntryGroupToCache() {
        this.cachingClient.put("CacheAdministrator-EntryGroup-" + CachingUtil.getHostName(), this.entryGroup);
        this.log.info((Object)"CacheAdministrator EntryGroup Cached");
        this.entryGroupUpdate = System.currentTimeMillis();
    }

    public CachingClient getCachingClient() {
        return this.cachingClient;
    }

    public void setCachingClient(CachingClient cachingClient) {
        this.cachingClient = cachingClient;
    }

    @Override
    public EntryGroup updateEntryGroup(String contentKey, String groupKey, boolean wasFlushed) {
        this.entryGroup.updateEntryGroup(contentKey, groupKey, wasFlushed);
        this.dealEntryGroupToCache();
        return this.entryGroup;
    }

    @Override
    public EntryGroup removeRefurbishGroupsByKey(String contentKey, String groupKey) {
        this.entryGroup.removeRefurbishGroupsByKey(contentKey, groupKey);
        this.dealEntryGroupToCache();
        return this.entryGroup;
    }

    @Override
    public CacheEntry putCache(CacheEntry cacheEntry) {
        this.cachingClient.put(cacheEntry.getKey(), (Object)cacheEntry, cacheEntry.getExpiry());
        this.entryGroup.setEntryGroup(cacheEntry.getKey(), cacheEntry.getGroups());
        this.dealEntryGroupToCache();
        return cacheEntry;
    }

    @Override
    public CacheEntry putRefurbishGroupsByKey(CacheEntry cacheEntry) {
        this.entryGroup.putRefurbishGroupsByKey(cacheEntry.getKey(), cacheEntry.getGroups());
        this.dealEntryGroupToCache();
        return cacheEntry;
    }
}

