/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;

public class EntryGroup
implements Serializable {
    private static final long serialVersionUID = 3546198636668504333L;
    private boolean wasFlushed = false;
    protected String contentKey;
    protected String groupKey;
    protected HashMap groups = new HashMap();
    protected HashMap refurbishGroups = new HashMap();

    public EntryGroup(String contentKey, String groupKey) {
        this.contentKey = contentKey;
        this.groupKey = groupKey;
        this.setEntryGroup();
    }

    public EntryGroup() {
        this.groups = new HashMap();
        this.refurbishGroups = new HashMap();
    }

    public void remove(String groupKey) {
        this.groups.remove(groupKey);
    }

    public Hashtable getEntryGroup(String groupKey) {
        Object o;
        if (this.groups == null) {
            this.groups = new HashMap();
        }
        if ((o = this.groups.get(groupKey)) != null) {
            return (Hashtable)o;
        }
        return null;
    }

    public Hashtable getRefurbishGroups(String groupKey) {
        Object o;
        if (this.refurbishGroups == null) {
            this.refurbishGroups = new HashMap();
        }
        if ((o = this.refurbishGroups.get(groupKey)) != null) {
            return (Hashtable)o;
        }
        return null;
    }

    public Hashtable setEntryGroup(String contentKey, String groupKey) {
        this.contentKey = contentKey;
        this.groupKey = groupKey;
        this.setEntryGroup();
        return (Hashtable)this.groups.get(groupKey);
    }

    public void setEntryGroup() {
        Hashtable<String, Long> group;
        if (this.groups == null) {
            this.groups = new HashMap();
        }
        if ((group = (Hashtable<String, Long>)this.groups.get(this.groupKey)) == null) {
            group = new Hashtable<String, Long>();
        }
        group.put(this.contentKey, System.currentTimeMillis());
        this.groups.put(this.groupKey, group);
    }

    public synchronized Hashtable updateEntryGroup(String contentKey, String groupKey, boolean wasFlushed) {
        Hashtable group = this.getEntryGroup(groupKey);
        if (wasFlushed && group != null && !group.isEmpty()) {
            Hashtable<String, Long> refurbishGroup = this.getRefurbishGroups(groupKey);
            if (refurbishGroup == null) {
                refurbishGroup = new Hashtable<String, Long>();
            }
            refurbishGroup.putAll(group);
            refurbishGroup.remove(contentKey);
            refurbishGroup.put("created", System.currentTimeMillis());
            this.refurbishGroups.put(groupKey, refurbishGroup);
        }
        return (Hashtable)this.refurbishGroups.get(groupKey);
    }

    public synchronized Hashtable removeRefurbishGroupsByKey(String contentKey, String groupKey) {
        Hashtable refurbishGroup = this.getRefurbishGroups(groupKey);
        if (refurbishGroup == null) {
            refurbishGroup = new Hashtable();
        }
        refurbishGroup.remove(contentKey);
        return this.refurbishGroups.put(groupKey, refurbishGroup);
    }

    public synchronized Hashtable putRefurbishGroupsByKey(String contentKey, String groupKey) {
        Hashtable<String, Long> refurbishGroup = this.getRefurbishGroups(groupKey);
        if (refurbishGroup == null) {
            refurbishGroup = new Hashtable<String, Long>();
        }
        refurbishGroup.put(contentKey, System.currentTimeMillis());
        return this.refurbishGroups.put(groupKey, refurbishGroup);
    }
}

