/*
 * Decompiled with CFR 0.152.
 */
package com.dmx.cache.base;

import java.io.Serializable;

public class CacheEntry
implements Serializable {
    private static final byte NOT_YET = -1;
    public static final int INDEFINITE_EXPIRY = -1;
    private Object content = null;
    private String groups;
    private String key;
    private boolean wasFlushed = false;
    private long created = -1L;
    private long lastUpdate = -1L;
    private int expiry = 0;

    public CacheEntry(String key, String groups, Object value, int expiry) {
        this.key = key;
        if (groups != null) {
            this.groups = groups;
        }
        this.content = value;
        this.expiry = expiry;
        this.created = System.currentTimeMillis();
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setContent(Object value) {
        this.content = value;
        this.lastUpdate = System.currentTimeMillis();
        this.wasFlushed = false;
    }

    public Object getContent() {
        return this.content;
    }

    public long getCreated() {
        return this.created;
    }

    public void setGroups(String groups) {
        this.groups = groups != null ? groups : null;
        this.lastUpdate = System.currentTimeMillis();
    }

    public String getGroups() {
        return this.groups;
    }

    public String getKey() {
        return this.key;
    }

    public void setLastUpdate(long update) {
        this.lastUpdate = update;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isNew() {
        return this.lastUpdate == -1L;
    }

    public void flush() {
        this.wasFlushed = true;
    }

    public boolean needsRefresh(int refreshPeriod) {
        boolean needsRefresh = this.lastUpdate == -1L ? true : (this.wasFlushed ? true : (refreshPeriod == 0 ? true : refreshPeriod >= 0 && System.currentTimeMillis() >= this.lastUpdate + (long)refreshPeriod * 1000L));
        return needsRefresh;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }
}

