/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.C40Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 3;
    }

    @Override
    public void encode(EncoderContext context) {
        StringBuilder buffer = new StringBuilder();
        while (context.hasMoreCharacters()) {
            char c = context.getCurrentChar();
            ++context.pos;
            this.encodeChar(c, buffer);
            if (buffer.length() % 3 != 0) continue;
            X12Encoder.writeNextTriplet(context, buffer);
            if (HighLevelEncoder.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode()) == this.getEncodingMode()) continue;
            context.signalEncoderChange(0);
            break;
        }
        this.handleEOD(context, buffer);
    }

    @Override
    int encodeChar(char c, StringBuilder sb) {
        switch (c) {
            case '\r': {
                sb.append('\u0000');
                break;
            }
            case '*': {
                sb.append('\u0001');
                break;
            }
            case '>': {
                sb.append('\u0002');
                break;
            }
            case ' ': {
                sb.append('\u0003');
                break;
            }
            default: {
                if (c >= '0' && c <= '9') {
                    sb.append((char)(c - 48 + 4));
                    break;
                }
                if (c >= 'A' && c <= 'Z') {
                    sb.append((char)(c - 65 + 14));
                    break;
                }
                HighLevelEncoder.illegalCharacter(c);
            }
        }
        return 1;
    }

    @Override
    void handleEOD(EncoderContext context, StringBuilder buffer) {
        context.updateSymbolInfo();
        int available = context.getSymbolInfo().getDataCapacity() - context.getCodewordCount();
        int count = buffer.length();
        context.pos -= count;
        if (context.getRemainingCharacters() > 1 || available > 1 || context.getRemainingCharacters() != available) {
            context.writeCodeword('\u00fe');
        }
        if (context.getNewEncoding() < 0) {
            context.signalEncoderChange(0);
        }
    }
}

