/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.LiteralByteString;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;

final class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;
    private static final long serialVersionUID = 1L;

    BoundedByteString(byte[] bytes, int offset, int length) {
        super(bytes);
        BoundedByteString.checkRange(offset, offset + length, bytes.length);
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    public byte byteAt(int index) {
        BoundedByteString.checkIndex(index, this.size());
        return this.bytes[this.bytesOffset + index];
    }

    public int size() {
        return this.bytesLength;
    }

    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    Object writeReplace() {
        return new LiteralByteString(this.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
    }
}

