/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum AddressType implements StringJoin.UrlValue
{
    STREET_ADDRESS("street_address"),
    ROUTE("route"),
    INTERSECTION("intersection"),
    POLITICAL("political"),
    COUNTRY("country"),
    ADMINISTRATIVE_AREA_LEVEL_1("administrative_area_level_1"),
    ADMINISTRATIVE_AREA_LEVEL_2("administrative_area_level_2"),
    ADMINISTRATIVE_AREA_LEVEL_3("administrative_area_level_3"),
    ADMINISTRATIVE_AREA_LEVEL_4("administrative_area_level_4"),
    ADMINISTRATIVE_AREA_LEVEL_5("administrative_area_level_5"),
    COLLOQUIAL_AREA("colloquial_area"),
    LOCALITY("locality"),
    SUBLOCALITY("sublocality"),
    SUBLOCALITY_LEVEL_1("sublocality_level_1"),
    SUBLOCALITY_LEVEL_2("sublocality_level_2"),
    SUBLOCALITY_LEVEL_3("sublocality_level_3"),
    SUBLOCALITY_LEVEL_4("sublocality_level_4"),
    SUBLOCALITY_LEVEL_5("sublocality_level_5"),
    NEIGHBORHOOD("neighborhood"),
    PREMISE("premise"),
    SUBPREMISE("subpremise"),
    POSTAL_CODE("postal_code"),
    NATURAL_FEATURE("natural_feature"),
    AIRPORT("airport"),
    UNIVERSITY("university"),
    PARK("park"),
    POINT_OF_INTEREST("point_of_interest"),
    ESTABLISHMENT("establishment"),
    BUS_STATION("bus_station"),
    TRAIN_STATION("train_station"),
    TRANSIT_STATION("transit_station"),
    UNKNOWN("unknown");

    private static Logger log;
    private final String addressType;

    private AddressType(String addressType) {
        this.addressType = addressType;
    }

    public String toString() {
        return this.addressType;
    }

    @Override
    public String toUrlValue() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException("Shouldn't use AddressType.UNKNOWN in a request.");
        }
        return this.addressType;
    }

    public static AddressType lookup(String addressType) {
        if (addressType.equalsIgnoreCase(STREET_ADDRESS.toString())) {
            return STREET_ADDRESS;
        }
        if (addressType.equalsIgnoreCase(ROUTE.toString())) {
            return ROUTE;
        }
        if (addressType.equalsIgnoreCase(INTERSECTION.toString())) {
            return INTERSECTION;
        }
        if (addressType.equalsIgnoreCase(POLITICAL.toString())) {
            return POLITICAL;
        }
        if (addressType.equalsIgnoreCase(COUNTRY.toString())) {
            return COUNTRY;
        }
        if (addressType.equalsIgnoreCase(ADMINISTRATIVE_AREA_LEVEL_1.toString())) {
            return ADMINISTRATIVE_AREA_LEVEL_1;
        }
        if (addressType.equalsIgnoreCase(ADMINISTRATIVE_AREA_LEVEL_2.toString())) {
            return ADMINISTRATIVE_AREA_LEVEL_2;
        }
        if (addressType.equalsIgnoreCase(ADMINISTRATIVE_AREA_LEVEL_3.toString())) {
            return ADMINISTRATIVE_AREA_LEVEL_3;
        }
        if (addressType.equalsIgnoreCase(ADMINISTRATIVE_AREA_LEVEL_4.toString())) {
            return ADMINISTRATIVE_AREA_LEVEL_4;
        }
        if (addressType.equalsIgnoreCase(ADMINISTRATIVE_AREA_LEVEL_5.toString())) {
            return ADMINISTRATIVE_AREA_LEVEL_5;
        }
        if (addressType.equalsIgnoreCase(COLLOQUIAL_AREA.toString())) {
            return COLLOQUIAL_AREA;
        }
        if (addressType.equalsIgnoreCase(LOCALITY.toString())) {
            return LOCALITY;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY.toString())) {
            return SUBLOCALITY;
        }
        if (addressType.equalsIgnoreCase(NEIGHBORHOOD.toString())) {
            return NEIGHBORHOOD;
        }
        if (addressType.equalsIgnoreCase(PREMISE.toString())) {
            return PREMISE;
        }
        if (addressType.equalsIgnoreCase(SUBPREMISE.toString())) {
            return SUBPREMISE;
        }
        if (addressType.equalsIgnoreCase(POSTAL_CODE.toString())) {
            return POSTAL_CODE;
        }
        if (addressType.equalsIgnoreCase(NATURAL_FEATURE.toString())) {
            return NATURAL_FEATURE;
        }
        if (addressType.equalsIgnoreCase(AIRPORT.toString())) {
            return AIRPORT;
        }
        if (addressType.equalsIgnoreCase(UNIVERSITY.toString())) {
            return UNIVERSITY;
        }
        if (addressType.equalsIgnoreCase(PARK.toString())) {
            return PARK;
        }
        if (addressType.equalsIgnoreCase(POINT_OF_INTEREST.toString())) {
            return POINT_OF_INTEREST;
        }
        if (addressType.equalsIgnoreCase(ESTABLISHMENT.toString())) {
            return ESTABLISHMENT;
        }
        if (addressType.equalsIgnoreCase(BUS_STATION.toString())) {
            return BUS_STATION;
        }
        if (addressType.equalsIgnoreCase(TRAIN_STATION.toString())) {
            return TRAIN_STATION;
        }
        if (addressType.equalsIgnoreCase(TRANSIT_STATION.toString())) {
            return TRANSIT_STATION;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY_LEVEL_1.toString())) {
            return SUBLOCALITY_LEVEL_1;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY_LEVEL_2.toString())) {
            return SUBLOCALITY_LEVEL_2;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY_LEVEL_3.toString())) {
            return SUBLOCALITY_LEVEL_3;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY_LEVEL_4.toString())) {
            return SUBLOCALITY_LEVEL_4;
        }
        if (addressType.equalsIgnoreCase(SUBLOCALITY_LEVEL_5.toString())) {
            return SUBLOCALITY_LEVEL_5;
        }
        log.log(Level.WARNING, "Unknown address type '%s'", addressType);
        return UNKNOWN;
    }

    static {
        log = Logger.getLogger(AddressType.class.getName());
    }
}

