/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.ByteString;

public class UrlSigner {
    private final SecretKeySpec key;

    public UrlSigner(String keyString) {
        String base64 = keyString.replace('-', '+').replace('_', '/');
        ByteString decodedKey = ByteString.decodeBase64((String)base64);
        if (decodedKey == null) {
            throw new IllegalArgumentException("Private key is invalid.");
        }
        this.key = new SecretKeySpec(decodedKey.toByteArray(), "HmacSHA1");
    }

    public String getSignature(String path) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(this.key);
        byte[] digest = mac.doFinal(path.getBytes());
        return ByteString.of((byte[])digest).base64().replace('+', '-').replace('/', '_');
    }
}

