/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.maps.model.Fare;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Currency;

public class FareAdapter
extends TypeAdapter<Fare> {
    public Fare read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        Fare fare = new Fare();
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("currency".equals(key)) {
                fare.currency = Currency.getInstance(reader.nextString());
                continue;
            }
            if (!"value".equals(key)) continue;
            fare.value = new BigDecimal(reader.nextString());
        }
        reader.endObject();
        return fare;
    }

    public void write(JsonWriter out, Fare value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }
}

