/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.bigquery.storage.util.Errors;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import io.grpc.Metadata;
import io.grpc.Status;
import java.time.Duration;

@InternalApi
public class ApiResultRetryAlgorithm<ResponseT>
implements ResultRetryAlgorithm<ResponseT> {
    public static final Duration DEADLINE_SLEEP_DURATION = Duration.ofMillis(1L);
    private final BigQueryReadSettings.RetryAttemptListener retryAttemptListener;

    public ApiResultRetryAlgorithm() {
        this(null);
    }

    public ApiResultRetryAlgorithm(BigQueryReadSettings.RetryAttemptListener retryAttemptListener) {
        this.retryAttemptListener = retryAttemptListener;
    }

    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        if (prevThrowable != null) {
            Status status = Status.fromThrowable((Throwable)prevThrowable);
            Metadata metadata = Status.trailersFromThrowable((Throwable)prevThrowable);
            Errors.IsRetryableStatusResult result = Errors.isRetryableStatus(status, metadata);
            if (result.isRetryable) {
                Duration retryDelay = result.retryDelay;
                Duration randomizedRetryDelay = result.retryDelay;
                if (retryDelay == null) {
                    retryDelay = prevSettings.getRetryDelayDuration();
                    randomizedRetryDelay = DEADLINE_SLEEP_DURATION;
                }
                if (this.retryAttemptListener != null) {
                    this.retryAttemptListener.onRetryAttempt(status, metadata);
                }
                return TimedAttemptSettings.newBuilder().setGlobalSettings(prevSettings.getGlobalSettings()).setRetryDelayDuration(retryDelay).setRpcTimeout(prevSettings.getRpcTimeout()).setRandomizedRetryDelayDuration(randomizedRetryDelay).setAttemptCount(prevSettings.getAttemptCount() + 1).setFirstAttemptStartTimeNanos(prevSettings.getFirstAttemptStartTimeNanos()).build();
            }
        }
        return null;
    }

    public boolean shouldRetry(Throwable prevThrowable, ResponseT prevResponse) {
        if (prevThrowable != null) {
            Status status = Status.fromThrowable((Throwable)prevThrowable);
            Metadata metadata = Status.trailersFromThrowable((Throwable)prevThrowable);
            if (Errors.isRetryableStatus((Status)status, (Metadata)metadata).isRetryable) {
                return true;
            }
        }
        return prevThrowable instanceof ApiException && ((ApiException)prevThrowable).isRetryable();
    }
}

