/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.Parser;

abstract class ExpressionNode
extends Node {
    ExpressionNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    boolean isTrue(EvaluationContext context) {
        Object value = this.evaluate(context);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value != null;
    }

    boolean isDefinedAndTrue(EvaluationContext context) {
        return this.isTrue(context);
    }

    int intValue(EvaluationContext context) {
        Object value = this.evaluate(context);
        if (!(value instanceof Integer)) {
            throw this.evaluationException("Arithemtic is only available on integers, not " + ExpressionNode.show(value));
        }
        return (Integer)value;
    }

    private static String show(Object value) {
        if (value == null) {
            return "null";
        }
        return value + " (a " + value.getClass().getName() + ")";
    }

    static class NotExpressionNode
    extends ExpressionNode {
        private final ExpressionNode expr;

        NotExpressionNode(ExpressionNode expr) {
            super(expr.resourceName, expr.lineNumber);
            this.expr = expr;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            return !this.expr.isTrue(context);
        }
    }

    static class BinaryExpressionNode
    extends ExpressionNode {
        final ExpressionNode lhs;
        final Parser.Operator op;
        final ExpressionNode rhs;

        BinaryExpressionNode(ExpressionNode lhs, Parser.Operator op, ExpressionNode rhs) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            switch (this.op) {
                case OR: {
                    return this.lhs.isTrue(context) || this.rhs.isTrue(context);
                }
                case AND: {
                    return this.lhs.isTrue(context) && this.rhs.isTrue(context);
                }
                case EQUAL: {
                    return this.equal(context);
                }
                case NOT_EQUAL: {
                    return !this.equal(context);
                }
            }
            int lhsInt = this.lhs.intValue(context);
            int rhsInt = this.rhs.intValue(context);
            switch (this.op) {
                case LESS: {
                    return lhsInt < rhsInt;
                }
                case LESS_OR_EQUAL: {
                    return lhsInt <= rhsInt;
                }
                case GREATER: {
                    return lhsInt > rhsInt;
                }
                case GREATER_OR_EQUAL: {
                    return lhsInt >= rhsInt;
                }
                case PLUS: {
                    return lhsInt + rhsInt;
                }
                case MINUS: {
                    return lhsInt - rhsInt;
                }
                case TIMES: {
                    return lhsInt * rhsInt;
                }
                case DIVIDE: {
                    return lhsInt / rhsInt;
                }
                case REMAINDER: {
                    return lhsInt % rhsInt;
                }
            }
            throw new AssertionError((Object)this.op);
        }

        private boolean equal(EvaluationContext context) {
            Object rhsValue;
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == (rhsValue = this.rhs.evaluate(context))) {
                return true;
            }
            if (lhsValue == null || rhsValue == null) {
                return false;
            }
            if (lhsValue.getClass().equals(rhsValue.getClass())) {
                return lhsValue.equals(rhsValue);
            }
            return lhsValue.toString().equals(rhsValue.toString());
        }
    }
}

