/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleCredentials
extends OAuth2Credentials {
    private static final long serialVersionUID = -1522852442442473691L;
    static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    static final String USER_FILE_TYPE = "authorized_user";
    static final String SERVICE_ACCOUNT_FILE_TYPE = "service_account";
    private static final DefaultCredentialsProvider defaultCredentialsProvider = new DefaultCredentialsProvider();

    public static GoogleCredentials create(AccessToken accessToken) {
        return GoogleCredentials.newBuilder().setAccessToken(accessToken).build();
    }

    public static GoogleCredentials getApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault(OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials getApplicationDefault(HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull((Object)transportFactory);
        return defaultCredentialsProvider.getDefaultCredentials(transportFactory);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream) throws IOException {
        return GoogleCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull((Object)credentialsStream);
        Preconditions.checkNotNull((Object)transportFactory);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = (GenericJson)parser.parseAndClose(credentialsStream, OAuth2Utils.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get((Object)"type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if (USER_FILE_TYPE.equals(fileType)) {
            return UserCredentials.fromJson((Map<String, Object>)fileContents, transportFactory);
        }
        if (SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return ServiceAccountCredentials.fromJson((Map<String, Object>)fileContents, transportFactory);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s' or '%s'.", fileType, USER_FILE_TYPE, SERVICE_ACCOUNT_FILE_TYPE));
    }

    static Map<String, List<String>> addQuotaProjectIdToRequestMetadata(String quotaProjectId, Map<String, List<String>> requestMetadata) {
        Preconditions.checkNotNull(requestMetadata);
        HashMap<String, List<String>> newRequestMetadata = new HashMap<String, List<String>>(requestMetadata);
        if (quotaProjectId != null && !requestMetadata.containsKey(QUOTA_PROJECT_ID_HEADER_KEY)) {
            newRequestMetadata.put(QUOTA_PROJECT_ID_HEADER_KEY, Collections.singletonList(quotaProjectId));
        }
        return Collections.unmodifiableMap(newRequestMetadata);
    }

    protected GoogleCredentials() {
        this(null);
    }

    public GoogleCredentials(AccessToken accessToken) {
        super(accessToken);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean createScopedRequired() {
        return false;
    }

    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this;
    }

    public GoogleCredentials createScoped(String ... scopes) {
        return this.createScoped((Collection<String>)ImmutableList.copyOf((Object[])scopes));
    }

    public GoogleCredentials createDelegated(String user) {
        return this;
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        protected Builder() {
        }

        protected Builder(GoogleCredentials credentials) {
            this.setAccessToken(credentials.getAccessToken());
        }

        @Override
        public GoogleCredentials build() {
            return new GoogleCredentials(this.getAccessToken());
        }

        @Override
        public Builder setAccessToken(AccessToken token) {
            super.setAccessToken(token);
            return this;
        }
    }
}

