/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor.pagination;

import com.github.yulichang.interceptor.pagination.ParseHelper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.ParameterExpression;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

public class SqlSourceWrapper {
    private static final String PARAMETER_PROPERTIES = "javaType,jdbcType,mode,numericScale,resultMap,typeHandler,jdbcTypeName";
    private final Configuration configuration;
    private final SqlNode rootSqlNode;

    public SqlSourceWrapper(Configuration configuration, SqlNode rootSqlNode) {
        this.configuration = configuration;
        this.rootSqlNode = rootSqlNode;
    }

    public String getSql(Object parameterObject) {
        DynamicContext context = new DynamicContext(this.configuration, parameterObject);
        this.rootSqlNode.apply(context);
        Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
        return this.parse(context.getSql(), parameterType, context.getBindings());
    }

    public String parse(String originalSql, Class<?> parameterType, Map<String, Object> additionalParameters) {
        ParameterMappingTokenHandler handler = new ParameterMappingTokenHandler(this.configuration, parameterType, additionalParameters){

            @Override
            public String handleToken(String content) {
                super.handleToken(content);
                return ParseHelper.format.apply("");
            }
        };
        GenericTokenParser parser = new GenericTokenParser("#{", "}", (TokenHandler)handler);
        String sql = this.configuration.isShrinkWhitespacesInSql() ? parser.parse(SqlSourceBuilder.removeExtraWhitespaces((String)originalSql)) : parser.parse(originalSql);
        return sql;
    }

    private static class ParameterMappingTokenHandler
    extends BaseBuilder
    implements TokenHandler {
        private final List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        private final Class<?> parameterType;
        private final MetaObject metaParameters;

        public ParameterMappingTokenHandler(Configuration configuration, Class<?> parameterType, Map<String, Object> additionalParameters) {
            super(configuration);
            this.parameterType = parameterType;
            this.metaParameters = configuration.newMetaObject(additionalParameters);
        }

        public List<ParameterMapping> getParameterMappings() {
            return this.parameterMappings;
        }

        public String handleToken(String content) {
            this.parameterMappings.add(this.buildParameterMapping(content));
            return "?";
        }

        private ParameterMapping buildParameterMapping(String content) {
            MetaClass metaClass;
            Map<String, String> propertiesMap = this.parseParameterMapping(content);
            String property = propertiesMap.get("property");
            Class<Object> propertyType = this.metaParameters.hasGetter(property) ? this.metaParameters.getGetterType(property) : (this.typeHandlerRegistry.hasTypeHandler(this.parameterType) ? this.parameterType : (JdbcType.CURSOR.name().equals(propertiesMap.get("jdbcType")) ? ResultSet.class : (property == null || Map.class.isAssignableFrom(this.parameterType) ? Object.class : ((metaClass = MetaClass.forClass(this.parameterType, (ReflectorFactory)this.configuration.getReflectorFactory())).hasGetter(property) ? metaClass.getGetterType(property) : Object.class))));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, propertyType);
            Class javaType = propertyType;
            String typeHandlerAlias = null;
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if ("javaType".equals(name)) {
                    javaType = this.resolveClass(value);
                    builder.javaType(javaType);
                    continue;
                }
                if ("jdbcType".equals(name)) {
                    builder.jdbcType(this.resolveJdbcType(value));
                    continue;
                }
                if ("mode".equals(name)) {
                    builder.mode(this.resolveParameterMode(value));
                    continue;
                }
                if ("numericScale".equals(name)) {
                    builder.numericScale(Integer.valueOf(value));
                    continue;
                }
                if ("resultMap".equals(name)) {
                    builder.resultMapId(value);
                    continue;
                }
                if ("typeHandler".equals(name)) {
                    typeHandlerAlias = value;
                    continue;
                }
                if ("jdbcTypeName".equals(name)) {
                    builder.jdbcTypeName(value);
                    continue;
                }
                if ("property".equals(name)) continue;
                if ("expression".equals(name)) {
                    throw new BuilderException("Expression based parameters are not supported yet");
                }
                throw new BuilderException("An invalid property '" + name + "' was found in mapping #{" + content + "}.  Valid properties are " + SqlSourceWrapper.PARAMETER_PROPERTIES);
            }
            if (typeHandlerAlias != null) {
                builder.typeHandler(this.resolveTypeHandler(javaType, typeHandlerAlias));
            }
            return builder.build();
        }

        private Map<String, String> parseParameterMapping(String content) {
            try {
                return new ParameterExpression(content);
            }
            catch (BuilderException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BuilderException("Parsing error was found in mapping #{" + content + "}.  Check syntax #{property|(expression), var1=value1, var2=value2, ...} ", (Throwable)ex);
            }
        }
    }
}

