/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.github.yulichang.toolkit.MPJTableMapperHelper;
import java.util.Objects;
import java.util.Optional;
import org.apache.ibatis.session.SqlSession;

public class SpringContentUtils {
    private static SpringContext springContext;

    public static void setSpringContext(SpringContext springContext) {
        if (Objects.isNull(SpringContentUtils.springContext)) {
            SpringContentUtils.springContext = springContext;
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        return Optional.ofNullable(springContext).map(c -> c.getBean(clazz)).orElse(null);
    }

    public static <T> void getBeansOfType(Class<T> clazz) {
        Optional.ofNullable(springContext).ifPresent(c -> c.getBeansOfType(clazz));
    }

    public static <T> T getMapper(Class<?> clazz) {
        if (Objects.isNull(springContext)) {
            SqlSession session = SqlHelper.sqlSession(clazz);
            Assert.notNull((Object)session, (String)"mapper not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
            BaseMapper mapper = SqlHelper.getMapper(clazz, (SqlSession)session);
            Assert.notNull((Object)mapper, (String)"mapper not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
            return (T)mapper;
        }
        Class<?> mapper = MPJTableMapperHelper.getMapper(clazz);
        Assert.notNull(mapper, (String)"mapper not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
        Object bean = SpringContentUtils.getBean(mapper);
        Assert.notNull(bean, (String)"mapper not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
        return (T)bean;
    }

    private SpringContentUtils() {
    }

    public static interface SpringContext {
        public <T> T getBean(Class<T> var1);

        public <T> void getBeansOfType(Class<T> var1);
    }
}

