/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.github.yulichang.toolkit.ReflectionKit;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MPJReflectionKit {
    private static final Map<Class<?>, Map<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<String, Field> EMPTY_MAP = new HashMap<String, Field>();

    public static Class<?> getGenericType(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        Type argument = actualTypeArguments[0];
        if (argument instanceof WildcardType) {
            Type[] types = ((WildcardType)argument).getUpperBounds();
            return (Class)types[0];
        }
        return (Class)argument;
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        if (clazz == null) {
            return EMPTY_MAP;
        }
        Map<String, Field> fieldMap = CLASS_FIELD_CACHE.get(clazz);
        if (fieldMap != null) {
            return fieldMap;
        }
        Map<String, Field> map = ReflectionKit.getFieldMap(clazz);
        CLASS_FIELD_CACHE.put(clazz, map);
        return map;
    }
}

