/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.MPJReflectionKit;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.toolkit.support.IdeaProxyLambdaMeta;
import com.github.yulichang.toolkit.support.LambdaMeta;
import com.github.yulichang.toolkit.support.ReflectLambdaMeta;
import com.github.yulichang.toolkit.support.SerializedLambda;
import com.github.yulichang.toolkit.support.ShadowLambdaMeta;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.property.PropertyNamer;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();

    public static <T> String getName(SFunction<T, ?> fn) {
        LambdaMeta extract = LambdaUtils.extract(fn);
        String name = PropertyNamer.methodToProperty((String)extract.getImplMethodName());
        if (Character.isUpperCase(name.charAt(0))) {
            Map<String, Field> map = MPJReflectionKit.getFieldMap(extract.getInstantiatedClass());
            if (map.containsKey(name)) {
                return name;
            }
            return map.keySet().stream().filter(i -> i.equalsIgnoreCase(name)).findFirst().orElse(null);
        }
        return name;
    }

    public static <T> Class<T> getEntityClass(SFunction<T, ?> fn) {
        return LambdaUtils.extract(fn).getInstantiatedClass();
    }

    public static <T> LambdaMeta extract(SFunction<T, ?> func) {
        if (func instanceof Proxy) {
            return new IdeaProxyLambdaMeta((Proxy)func);
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            return new ReflectLambdaMeta((java.lang.invoke.SerializedLambda)ReflectionKit.setAccessible(method).invoke(func, new Object[0]));
        }
        catch (Throwable e) {
            return new ShadowLambdaMeta(SerializedLambda.extract(func));
        }
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    public static void installCache(TableInfo tableInfo) {
        COLUMN_CACHE_MAP.put(tableInfo.getEntityType().getName(), LambdaUtils.createColumnCacheMap(tableInfo));
    }

    private static Map<String, ColumnCache> createColumnCacheMap(TableInfo info) {
        HashMap map;
        if (info.havePK()) {
            map = CollectionUtils.newHashMapWithExpectedSize((int)(info.getFieldList().size() + 1));
            map.put(LambdaUtils.formatKey(info.getKeyProperty()), new ColumnCache(info.getKeyColumn(), info.getKeySqlSelect(), null, info.getKeyProperty(), true, info.getKeyType()));
        } else {
            map = CollectionUtils.newHashMapWithExpectedSize((int)info.getFieldList().size());
        }
        info.getFieldList().forEach(i -> map.put(LambdaUtils.formatKey(i.getProperty()), new ColumnCache(i.getColumn(), i.getSqlSelect(), (TableFieldInfo)i, null, false, null)));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return (Map)CollectionUtils.computeIfAbsent(COLUMN_CACHE_MAP, (Object)clazz.getName(), key -> {
            TableInfo info = TableInfoHelper.getTableInfo((Class)clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

