/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.method.MPJResultType;
import com.github.yulichang.toolkit.support.SelectColumn;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.github.yulichang.wrapper.resultmap.MybatisLabel;
import com.github.yulichang.wrapper.resultmap.Result;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MPJInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(MPJInterceptor.class);
    private static final List<ResultMapping> EMPTY_RESULT_MAPPING = new ArrayList<ResultMapping>(0);
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args[0] instanceof MappedStatement) {
            MappedStatement ms = (MappedStatement)args[0];
            if (args[1] instanceof Map) {
                ResultMap resultMap;
                List list;
                Class clazz;
                Object ew;
                Map map = (Map)args[1];
                Object v0 = ew = map.containsKey("ew") ? map.get("ew") : null;
                if (!map.containsKey("paramType_Gr8re1Ee")) {
                    map.put("paramType_Gr8re1Ee", Objects.nonNull(ew) && ew instanceof MPJBaseJoin);
                } else {
                    logger.warn(String.format("\u8bf7\u4e0d\u8981\u4f7f\u7528MPJ\u9884\u7559\u53c2\u6570\u540d %s", "paramType_Gr8re1Ee"));
                }
                if (CollectionUtils.isNotEmpty((Map)map) && map.containsKey("resultTypeClass_Eg1sG") && Objects.nonNull(clazz = (Class)map.get("resultTypeClass_Eg1sG")) && CollectionUtils.isNotEmpty((Collection)(list = ms.getResultMaps())) && (resultMap = (ResultMap)list.get(0)).getType() == MPJResultType.class) {
                    args[0] = this.getMappedStatement(ms, clazz, ew);
                }
            }
        }
        return invocation.proceed();
    }

    public MappedStatement getMappedStatement(MappedStatement ms, Class<?> resultType, Object ew) {
        MappedStatement statement;
        String id = ms.getId() + "_" + resultType.getName();
        if (ew instanceof MPJLambdaWrapper && ((MPJLambdaWrapper)ew).isResultMap()) {
            return this.buildMappedStatement(ms, resultType, ew, id);
        }
        Map<Configuration, MappedStatement> statementMap = MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statement = statementMap.get(ms.getConfiguration()))) {
            return statement;
        }
        MappedStatement mappedStatement = this.buildMappedStatement(ms, resultType, ew, id);
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            MS_CACHE.put(id, statementMap);
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }

    private MappedStatement buildMappedStatement(MappedStatement ms, Class<?> resultType, Object ew, String id) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        List<ResultMap> resultMaps = this.buildResultMap(ms, resultType, ew);
        builder.resultMaps(resultMaps);
        return builder.build();
    }

    private List<ResultMap> buildResultMap(MappedStatement ms, Class<?> resultType, Object obj) {
        ArrayList<ResultMap> result = new ArrayList<ResultMap>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(resultType);
        String id = ms.getId() + "." + "mybatis-plus" + "_" + resultType.getName();
        if (!(obj instanceof MPJLambdaWrapper) || Map.class.isAssignableFrom(resultType) || Collection.class.isAssignableFrom(resultType)) {
            result.add(this.getDefaultResultMap(tableInfo, ms, resultType, id));
            return result;
        }
        MPJLambdaWrapper wrapper = (MPJLambdaWrapper)obj;
        Map fieldMap = ReflectionKit.getFieldMap(resultType);
        List<SelectColumn> columnList = wrapper.getSelectColumns();
        columnList.removeIf(SelectColumn::isLabel);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>(columnList.size());
        for (SelectColumn i2 : columnList) {
            Field f;
            ResultMapping.Builder builder;
            TableFieldInfo info = i2.getTableFieldInfo();
            if (StringUtils.isNotBlank((CharSequence)i2.getAlias())) {
                builder = new ResultMapping.Builder(ms.getConfiguration(), i2.getAlias(), i2.getAlias(), this.getAliasField(resultType, fieldMap, i2.getAlias()));
                if (i2.getFuncEnum() == null || StringUtils.isBlank((CharSequence)i2.getFuncEnum().getSql())) {
                    f = (Field)fieldMap.get(i2.getAlias());
                    if (f == null) continue;
                    if (info != null && info.getTypeHandler() != null && info.getTypeHandler() != UnknownTypeHandler.class && f.getType() == info.getField().getType()) {
                        builder.typeHandler(this.getTypeHandler(ms, info));
                    }
                }
                resultMappings.add(builder.build());
                continue;
            }
            if (info != null) {
                if (i2.getFuncEnum() == null || StringUtils.isBlank((CharSequence)i2.getFuncEnum().getSql())) {
                    builder = new ResultMapping.Builder(ms.getConfiguration(), info.getProperty(), StringUtils.getTargetColumn((String)info.getColumn()), info.getPropertyType());
                    f = (Field)fieldMap.get(info.getProperty());
                    if (f == null) continue;
                    if (f.getType() == info.getField().getType() && info.getTypeHandler() != null && info.getTypeHandler() != UnknownTypeHandler.class) {
                        builder.typeHandler(this.getTypeHandler(ms, info));
                    }
                    builder.javaType(f.getType());
                    resultMappings.add(builder.build());
                    continue;
                }
                resultMappings.add(new ResultMapping.Builder(ms.getConfiguration(), info.getProperty(), StringUtils.getTargetColumn((String)info.getColumn()), info.getPropertyType()).build());
                continue;
            }
            resultMappings.add(new ResultMapping.Builder(ms.getConfiguration(), i2.getTagProperty(), StringUtils.getTargetColumn((String)i2.getColumnName()), i2.getKeyType()).flags(Collections.singletonList(ResultFlag.ID)).build());
        }
        Set<String> columnSet = resultMappings.stream().map(ResultMapping::getColumn).collect(Collectors.toSet());
        resultMappings.removeIf(i -> !fieldMap.containsKey(i.getProperty()));
        if (wrapper.isResultMap()) {
            Iterator<MybatisLabel<?, ?>> iterator = wrapper.getResultMapMybatisLabel().iterator();
            while (iterator.hasNext()) {
                MybatisLabel<?, ?> o;
                MybatisLabel<?, ?> label = o = iterator.next();
                resultMappings.add(this.buildResult(ms, label, columnSet, columnList));
            }
        }
        result.add(new ResultMap.Builder(ms.getConfiguration(), id, resultType, resultMappings).build());
        return result;
    }

    private ResultMapping buildResult(MappedStatement ms, MybatisLabel<?, ?> mybatisLabel, Set<String> columnSet, List<SelectColumn> columnList) {
        String childId;
        List<Result> resultList = mybatisLabel.getResultList();
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        ArrayList<ResultMapping> childMapping = new ArrayList<ResultMapping>(resultList.size());
        for (Result r : resultList) {
            TableFieldInfo info;
            String columnName = r.getColumn();
            columnName = this.getColumn(columnSet, columnName);
            columnList.add(SelectColumn.of(mybatisLabel.getEntityClass(), r.getColumn(), null, Objects.equals(columnName, r.getColumn()) ? null : columnName, null, null, true, null));
            ResultMapping.Builder builder = new ResultMapping.Builder(ms.getConfiguration(), r.getProperty(), StringUtils.getTargetColumn((String)columnName), r.getJavaType());
            if (r.isId()) {
                builder.flags(Collections.singletonList(ResultFlag.ID));
            }
            if ((info = r.getTableFieldInfo()) != null && info.getTypeHandler() != null && info.getTypeHandler() != UnknownTypeHandler.class) {
                builder.typeHandler(this.getTypeHandler(ms, info));
            }
            childMapping.add(builder.build());
        }
        if (CollectionUtils.isEmpty(mybatisLabel.getMybatisLabels())) {
            childId = "MPJ_" + mybatisLabel.getEntityClass().getName() + "_" + mybatisLabel.getOfType().getName() + "_" + childMapping.stream().map(i -> "(" + (CollectionUtils.isEmpty((Collection)i.getFlags()) ? ResultFlag.CONSTRUCTOR : (ResultFlag)i.getFlags().get(0)) + "-" + i.getProperty() + "-" + i.getColumn() + ")").collect(Collectors.joining("-"));
        } else {
            StringBuilder sb = new StringBuilder("MPJ_[");
            for (MybatisLabel<?, ?> o : mybatisLabel.getMybatisLabels()) {
                ResultMapping result;
                if (Objects.isNull(o) || Objects.isNull(result = this.buildResult(ms, o, columnSet, columnList))) continue;
                childMapping.add(result);
                sb.append(result.getNestedResultMapId());
                sb.append("@");
            }
            sb.append("]");
            sb.append("_MPJ_").append(mybatisLabel.getEntityClass().getName()).append("_").append(mybatisLabel.getOfType().getName()).append("_");
            childId = sb + childMapping.stream().map(i -> "(" + (CollectionUtils.isEmpty((Collection)i.getFlags()) ? ResultFlag.CONSTRUCTOR : (ResultFlag)i.getFlags().get(0)) + "-" + i.getProperty() + "-" + i.getColumn() + ")").collect(Collectors.joining("-"));
        }
        if (!ms.getConfiguration().getResultMapNames().contains(childId)) {
            ResultMap build = new ResultMap.Builder(ms.getConfiguration(), childId, mybatisLabel.getOfType(), childMapping).build();
            MPJInterceptor.addResultMap(ms, childId, build);
        }
        return new ResultMapping.Builder(ms.getConfiguration(), mybatisLabel.getProperty()).javaType(mybatisLabel.getJavaType()).nestedResultMapId(childId).build();
    }

    private TypeHandler<?> getTypeHandler(MappedStatement ms, TableFieldInfo info) {
        TypeHandlerRegistry registry = ms.getConfiguration().getTypeHandlerRegistry();
        TypeHandler typeHandler = registry.getMappingTypeHandler(info.getTypeHandler());
        if (typeHandler == null) {
            typeHandler = registry.getInstance(info.getPropertyType(), info.getTypeHandler());
        }
        return typeHandler;
    }

    private String getColumn(Set<String> pool, String columnName) {
        if (!pool.contains(columnName)) {
            pool.add(columnName);
            return columnName;
        }
        columnName = "join_" + StringUtils.getTargetColumn((String)columnName);
        return this.getColumn(pool, columnName);
    }

    private ResultMap getDefaultResultMap(TableInfo tableInfo, MappedStatement ms, Class<?> resultType, String id) {
        if (tableInfo != null && tableInfo.isAutoInitResultMap()) {
            ResultMap resultMap = ms.getConfiguration().getResultMap(tableInfo.getResultMap());
            List resultMappings = resultMap.getResultMappings();
            List fieldList = ReflectionKit.getFieldList(resultType);
            fieldList.removeIf(i -> resultMappings.stream().anyMatch(r -> i.getName().equals(r.getProperty())));
            if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>(resultMappings);
                for (Field i2 : fieldList) {
                    resultMappingList.add(new ResultMapping.Builder(ms.getConfiguration(), i2.getName(), i2.getName(), i2.getType()).build());
                }
                return new ResultMap.Builder(ms.getConfiguration(), id, resultType, resultMappingList).build();
            }
        }
        return new ResultMap.Builder(ms.getConfiguration(), id, resultType, EMPTY_RESULT_MAPPING).build();
    }

    private Class<?> getAliasField(Class<?> resultType, Map<String, Field> fieldMap, String alias) {
        Field field = fieldMap.get(alias);
        Assert.notNull((Object)field, (String)"Result Class <%s> not find Field <%s>", (Object[])new Object[]{resultType.getSimpleName(), alias});
        return field.getType();
    }

    public static synchronized void addResultMap(MappedStatement ms, String key, ResultMap resultMap) {
        if (!ms.getConfiguration().getResultMapNames().contains(key)) {
            ms.getConfiguration().addResultMap(resultMap);
        }
    }
}

