/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.cost;

import com.xkzhangsan.time.cost.Cost;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

public final class SecondCost
implements Cost {
    private final String name;
    private final long millisecond;

    public SecondCost() {
        this.name = "";
        this.millisecond = System.currentTimeMillis();
    }

    public SecondCost(String name) {
        this.name = name;
        this.millisecond = System.currentTimeMillis();
    }

    @Override
    public long stop() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.millisecond);
    }

    @Override
    public void stopAndPrint() {
        System.out.println(this.stopAndFormat());
    }

    @Override
    public String stopAndFormat() {
        return this.name + " cost: " + this.stop() + " s";
    }

    @Override
    public String stopAccurate() {
        double result = (double)(System.currentTimeMillis() - this.millisecond) / 1000.0;
        return new BigDecimal(result).setScale(3, 1).toString();
    }

    @Override
    public void stopAccurateAndPrint() {
        System.out.println(this.stopAccurateAndFormat());
    }

    @Override
    public String stopAccurateAndFormat() {
        return this.name + " cost: " + this.stopAccurate() + " s";
    }
}

