/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingfudeshi.knife4j.extend.filter.basic;

import com.github.xingfudeshi.knife4j.extend.filter.basic.AbstractSecurityFilter;
import com.github.xingfudeshi.knife4j.extend.util.FilterUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;

public class JakartaServletSecurityBasicAuthFilter
extends AbstractSecurityFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        this.initServletConfig(filterConfig.getInitParameterNames(), filterConfig.getInitParameter("enableBasicAuth"), filterConfig.getInitParameter("userName"), filterConfig.getInitParameter("password"));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        if (this.isEnableBasicAuth() && this.match(url)) {
            String auth;
            Object sessionObject = request.getSession().getAttribute("KNIFE4J_BASIC_AUTH_SESSION");
            if (this.tryCommonBasic(url, sessionObject, auth = request.getHeader("Authorization"))) {
                if (sessionObject == null) {
                    request.getSession().setAttribute("KNIFE4J_BASIC_AUTH_SESSION", (Object)this.getUserName());
                }
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                FilterUtils.writeJakartaForbiddenCode(response);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        this.urlFilters = null;
    }

    @Generated
    public JakartaServletSecurityBasicAuthFilter() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JakartaServletSecurityBasicAuthFilter)) {
            return false;
        }
        JakartaServletSecurityBasicAuthFilter other = (JakartaServletSecurityBasicAuthFilter)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JakartaServletSecurityBasicAuthFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "JakartaServletSecurityBasicAuthFilter()";
    }
}

