/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.util.ClassUtils;
import springfox.documentation.RequestHandler;

public class RequestHandlerSelectorUtils {
    private static Function<Class<?>, Boolean> handlerPackage(String basePackage) {
        return input -> ClassUtils.getPackageName((Class)input).startsWith(basePackage);
    }

    public static Predicate<RequestHandler> basePackage(String basePackage) {
        return input -> RequestHandlerSelectorUtils.declaringClass(input).map(RequestHandlerSelectorUtils.handlerPackage(basePackage)).orElse(true);
    }

    public static Predicate<RequestHandler> baseMultipartPackage(String ... basePackages) {
        if (basePackages == null || basePackages.length == 0) {
            throw new IllegalArgumentException("basePackage can't empty!!");
        }
        ArrayList<String> basePackageList = new ArrayList<String>(Arrays.asList(basePackages));
        if (basePackageList.size() == 1) {
            return RequestHandlerSelectorUtils.basePackage((String)basePackageList.get(0));
        }
        Predicate<RequestHandler> predicate = RequestHandlerSelectorUtils.basePackage((String)basePackageList.get(0));
        for (int i = 1; i < basePackageList.size(); ++i) {
            predicate = predicate.or(RequestHandlerSelectorUtils.basePackage((String)basePackageList.get(i)));
        }
        return predicate;
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }
}

