/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.extension;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.extend.util.ExtensionUtils;
import io.swagger.v3.oas.models.Operation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class Knife4jJakartaOperationCustomizer
implements GlobalOperationCustomizer {
    private static final Logger log = LoggerFactory.getLogger(Knife4jJakartaOperationCustomizer.class);

    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        ApiOperationSupport operationSupport = (ApiOperationSupport)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), ApiOperationSupport.class);
        if (operationSupport != null) {
            String author = ExtensionUtils.getAuthors((ApiOperationSupport)operationSupport);
            if (StrUtil.isNotBlank((CharSequence)author)) {
                operation.addExtension("x-author", (Object)author);
            }
            if (operationSupport.order() != 0) {
                operation.addExtension("x-order", (Object)operationSupport.order());
            }
        } else {
            String author;
            ApiSupport apiSupport = (ApiSupport)AnnotationUtils.findAnnotation(handlerMethod.getMethod().getClass(), ApiSupport.class);
            if (apiSupport != null && StrUtil.isNotBlank((CharSequence)(author = ExtensionUtils.getAuthor((ApiSupport)apiSupport)))) {
                operation.addExtension("x-author", (Object)author);
            }
        }
        return operation;
    }
}

