/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.common.insight;

import com.github.xiaoymin.knife4j.core.util.Knife4jUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.insight.Knife4jInsightDiscoveryInfo;
import com.github.xiaoymin.knife4j.insight.Knife4jInsightRoute;
import com.github.xiaoymin.knife4j.spring.configuration.insight.Knife4jInsightProperties;
import com.github.xiaoymin.knife4j.spring.util.EnvironmentUtils;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.Environment;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class Knife4jInsightDiscoveryRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Knife4jInsightDiscoveryRunnable.class);
    final Environment environment;
    final Knife4jInsightProperties insightProperties;
    final BeanFactory beanFactory;

    @Override
    public void run() {
        try {
            String contextPath = "";
            String v1BasePath = this.environment.getProperty("server.context-path");
            String basePath = this.environment.getProperty("server.servlet.context-path");
            if (StrUtil.isNotBlank((CharSequence)v1BasePath) && !"/".equals(v1BasePath)) {
                contextPath = v1BasePath;
            } else if (StrUtil.isNotBlank((CharSequence)basePath) && !"/".equals(basePath)) {
                contextPath = basePath;
            }
            String serviceName = this.insightProperties.getServiceName();
            if (StrUtil.isBlank((CharSequence)serviceName)) {
                serviceName = EnvironmentUtils.resolveString(this.environment, "spring.application.name", "");
            }
            if (StrUtil.isBlank((CharSequence)serviceName)) {
                log.warn("service-name must set one,upload refused.");
                return;
            }
            DocumentationCache documentationCache = (DocumentationCache)this.beanFactory.getBean(DocumentationCache.class);
            Map allDocumentations = documentationCache.all();
            if (allDocumentations != null && !allDocumentations.isEmpty()) {
                ServiceModelToSwagger2Mapper swagger2Mapper = (ServiceModelToSwagger2Mapper)this.beanFactory.getBean(ServiceModelToSwagger2Mapper.class);
                JsonSerializer jsonSerializer = (JsonSerializer)this.beanFactory.getBean(JsonSerializer.class);
                Knife4jInsightDiscoveryInfo knife4jCloudDiscoveryInfo = new Knife4jInsightDiscoveryInfo();
                knife4jCloudDiscoveryInfo.setSpec("Swagger2");
                knife4jCloudDiscoveryInfo.setHost(InetAddress.getLocalHost().getHostAddress());
                knife4jCloudDiscoveryInfo.setPort(this.environment.getProperty("server.port"));
                knife4jCloudDiscoveryInfo.setAccessKey(this.insightProperties.getSecret());
                knife4jCloudDiscoveryInfo.setNamespace(this.insightProperties.getNamespace());
                knife4jCloudDiscoveryInfo.setServiceName(serviceName);
                for (Map.Entry entry : allDocumentations.entrySet()) {
                    if (!StrUtil.isNotBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
                    Knife4jInsightRoute knife4jCloudRoute = new Knife4jInsightRoute();
                    String path = contextPath + "/v2/api-docs" + "?group=" + (String)entry.getKey();
                    Swagger swagger = swagger2Mapper.mapDocumentation((Documentation)entry.getValue());
                    String content = jsonSerializer.toJson((Object)swagger).value();
                    knife4jCloudRoute.setGroupName((String)entry.getKey());
                    knife4jCloudRoute.setPath(path);
                    knife4jCloudRoute.setContent(content);
                    knife4jCloudDiscoveryInfo.addRoute(knife4jCloudRoute);
                }
                this.upload(knife4jCloudDiscoveryInfo, jsonSerializer);
            }
        }
        catch (Exception e) {
            log.debug("Knife4jInsight register fail,message:{}", (Object)e.getMessage());
        }
    }

    private void upload(Knife4jInsightDiscoveryInfo knife4jCloudDiscoveryInfo, JsonSerializer jsonSerializer) throws IOException {
        if (knife4jCloudDiscoveryInfo.getCloudRoutes() != null && !knife4jCloudDiscoveryInfo.getCloudRoutes().isEmpty()) {
            String body;
            String cloudApi = this.insightProperties.getServer() + "/api/cloud/upload";
            String result = Knife4jUtils.postRetry((String)cloudApi, (String)(body = jsonSerializer.toJson((Object)knife4jCloudDiscoveryInfo).value()), (int)3);
            if (result != null) {
                log.debug("Register To Knife4jInsight Finished");
            }
        } else {
            log.debug("No Found Swagger Information");
        }
    }

    @Generated
    public Knife4jInsightDiscoveryRunnable(Environment environment, Knife4jInsightProperties insightProperties, BeanFactory beanFactory) {
        this.environment = environment;
        this.insightProperties = insightProperties;
        this.beanFactory = beanFactory;
    }
}

