/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.util;

import com.github.xiaoymin.knife4j.core.enums.AnnotationClassEnums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;

public class RequestHandlerSelectorUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerSelectorUtils.class);
    static final Predicate<String> DEFAULT_PATHS_NONE = s -> false;

    private static Function<Class<?>, Boolean> handlerPackage(String basePackage) {
        return input -> ClassUtils.getPackageName((Class)input).startsWith(basePackage);
    }

    public static Predicate<RequestHandler> basePackage(String basePackage) {
        return input -> RequestHandlerSelectorUtils.declaringClass(input).map(RequestHandlerSelectorUtils.handlerPackage(basePackage)).orElse(true);
    }

    public static Predicate<String> multiplePathSelector(List<String> rules) {
        if (rules == null || rules.size() == 0) {
            return PathSelectors.none();
        }
        Predicate predicate = PathSelectors.ant((String)rules.get(0));
        if (rules.size() > 1) {
            for (int i = 1; i < rules.size(); ++i) {
                predicate = predicate.or(PathSelectors.ant((String)rules.get(i)));
            }
        }
        return predicate;
    }

    public static Predicate<RequestHandler> multiplePackage(String ... basePackages) {
        if (basePackages == null || basePackages.length == 0) {
            return RequestHandlerSelectors.none();
        }
        ArrayList<String> basePackageList = new ArrayList<String>(Arrays.asList(basePackages));
        Predicate<RequestHandler> predicate = RequestHandlerSelectorUtils.basePackage((String)basePackageList.get(0));
        if (basePackageList.size() > 1) {
            for (int i = 1; i < basePackageList.size(); ++i) {
                predicate = predicate.or(RequestHandlerSelectorUtils.basePackage((String)basePackageList.get(i)));
            }
        }
        return predicate;
    }

    public static Predicate<String> multipleAntPath(List<String> antPaths) {
        if (antPaths == null || antPaths.size() == 0) {
            return DEFAULT_PATHS_NONE;
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        Predicate<String> first = s -> antPathMatcher.match((String)antPaths.get(0), s);
        if (antPaths.size() > 1) {
            int i = 1;
            while (i < antPaths.size()) {
                int index = i++;
                first = first.or(s -> antPathMatcher.match((String)antPaths.get(index), s));
            }
        }
        return first;
    }

    public static Predicate<String> multipleRegexPath(List<String> regex) {
        if (regex == null || regex.size() == 0) {
            return DEFAULT_PATHS_NONE;
        }
        Predicate<String> first = s -> s.matches((String)regex.get(0));
        if (regex.size() > 1) {
            int i = 1;
            while (i < regex.size()) {
                int index = i++;
                first = first.or(s -> s.matches((String)regex.get(index)));
            }
        }
        return first;
    }

    public static Predicate<RequestHandler> multipleAnnotations(List<String> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return RequestHandlerSelectors.none();
        }
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        Predicate first = null;
        for (String annotationClassName : annotations) {
            try {
                Class clazz = ClassUtils.forName((String)annotationClassName, (ClassLoader)classLoader);
                if (clazz == null) continue;
                if (first == null) {
                    if (annotationClassName.equalsIgnoreCase(AnnotationClassEnums.Api.getFullPath())) {
                        first = RequestHandlerSelectors.withClassAnnotation((Class)clazz);
                        continue;
                    }
                    first = RequestHandlerSelectors.withMethodAnnotation((Class)clazz);
                    continue;
                }
                if (annotationClassName.equalsIgnoreCase(AnnotationClassEnums.Api.getFullPath())) {
                    first = first.or(RequestHandlerSelectors.withClassAnnotation((Class)clazz));
                    continue;
                }
                first = first.or(RequestHandlerSelectors.withMethodAnnotation((Class)clazz));
            }
            catch (Exception e) {
                log.warn("Cannot handle annotation type '" + annotationClassName + "' correctly, please make sure the path is correct,message:" + e.getMessage());
            }
        }
        return first != null ? first : RequestHandlerSelectors.none();
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }

    public static void main(String[] args) throws ClassNotFoundException {
    }
}

