/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.common.bean;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.DefaultPropertiesPropertySource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class SpringFoxEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String SPRING_MVC_MATCHING_STRATEGY = "spring.mvc.pathmatch.matching-strategy";
    static final String MATCHING_CLASS_NAME = "org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties.MatchingStrategy";
    Logger logger = LoggerFactory.getLogger(SpringFoxEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.logger.debug("springfox-post-processor..");
        if (ClassUtils.isPresent((String)MATCHING_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            this.logger.debug("Spring Boot Version Getter than 2.4.0,handle MatchingStrategy");
            String matchingStrategy = environment.getProperty(SPRING_MVC_MATCHING_STRATEGY);
            if (matchingStrategy == null || "".equals(matchingStrategy)) {
                HashMap<String, String> sources = new HashMap<String, String>();
                sources.put(SPRING_MVC_MATCHING_STRATEGY, "ant_path_matcher");
                DefaultPropertiesPropertySource defaultPropertiesPropertySource = new DefaultPropertiesPropertySource(sources);
                environment.getPropertySources().addLast((PropertySource)defaultPropertiesPropertySource);
            }
        }
    }
}

