/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.jfinal.extensions;

import com.github.xiaoymin.knife4j.jfinal.extensions.ReaderExtension;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReaderExtensions.class);
    private static final List<ReaderExtension> extensions;

    public static List<ReaderExtension> getExtensions() {
        return extensions;
    }

    static {
        Ordering<ReaderExtension> ordering = new Ordering<ReaderExtension>(){

            public int compare(ReaderExtension left, ReaderExtension right) {
                return Integer.compare(left.getPriority(), right.getPriority());
            }
        };
        ArrayList<ReaderExtension> loadedExtensions = new ArrayList<ReaderExtension>();
        for (ReaderExtension readerExtension : ordering.sortedCopy(ServiceLoader.load(ReaderExtension.class))) {
            LOGGER.debug("adding extension " + readerExtension);
            loadedExtensions.add(readerExtension);
        }
        extensions = Collections.unmodifiableList(loadedExtensions);
    }
}

