/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.jfinal.core;

import com.github.xiaoymin.knife4j.annotations.Ignore;
import com.github.xiaoymin.knife4j.core.io.ResourceUtil;
import com.github.xiaoymin.knife4j.core.util.AnnotationUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.jfinal.JFinalDocument;
import com.github.xiaoymin.knife4j.jfinal.context.TagContext;
import com.github.xiaoymin.knife4j.jfinal.core.ReaderContext;
import com.github.xiaoymin.knife4j.jfinal.extensions.JFinalReaderExtension;
import com.github.xiaoymin.knife4j.jfinal.model.JFinalControllerKey;
import com.github.xiaoymin.knife4j.jfinal.plugin.impl.TagPluginImpl;
import com.jfinal.core.ActionKey;
import com.jfinal.core.NotAction;
import io.swagger.annotations.Extension;
import io.swagger.annotations.OAuth2Definition;
import io.swagger.annotations.Scope;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;

public class Reader {
    private final Swagger swagger;
    private final JFinalDocument jFinalDocument;

    private Reader(Swagger swagger, JFinalDocument jFinalDocument) {
        this.swagger = swagger;
        this.jFinalDocument = jFinalDocument;
    }

    public static void read(Swagger swagger, JFinalDocument jFinalDocument) {
        Set classSet;
        Reader reader = new Reader(swagger, jFinalDocument);
        reader.readInfoConfig();
        if (jFinalDocument.getPackagePaths() != null && jFinalDocument.getPackagePaths().size() > 0 && (classSet = new ResourceUtil().find(jFinalDocument.getPackagePaths().toArray(new String[0])).getClasses()) != null && classSet.size() > 0) {
            for (Class cls : classSet) {
                Optional IgnoreOptional = AnnotationUtils.findAnnotation((Class)cls, Ignore.class);
                if (IgnoreOptional.isPresent()) continue;
                ReaderContext context = new ReaderContext(swagger, cls, "", null, false, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Parameter>());
                TagContext tagContext = new TagContext(cls);
                new TagPluginImpl().apply(tagContext);
                if (swagger.getTag(tagContext.getName()) == null) {
                    swagger.addTag(tagContext.build());
                }
                reader.read(context, null);
            }
        }
        if (jFinalDocument.getjFinalControllerKeys() != null && jFinalDocument.getjFinalControllerKeys().size() > 0) {
            for (JFinalControllerKey jFinalControllerKey : jFinalDocument.getjFinalControllerKeys()) {
                Optional IgnoreOptional = AnnotationUtils.findAnnotation(jFinalControllerKey.getControllerClazz(), Ignore.class);
                if (IgnoreOptional.isPresent()) continue;
                ReaderContext context = new ReaderContext(swagger, jFinalControllerKey.getControllerClazz(), "", null, false, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Parameter>());
                TagContext tagContext = new TagContext(jFinalControllerKey.getControllerClazz());
                new TagPluginImpl().apply(tagContext);
                if (swagger.getTag(tagContext.getName()) == null) {
                    swagger.addTag(tagContext.build());
                }
                reader.read(context, jFinalControllerKey.getKey());
            }
        }
    }

    private void read(ReaderContext context, String key) {
        SwaggerDefinition swaggerDefinition = context.getCls().getAnnotation(SwaggerDefinition.class);
        if (swaggerDefinition != null) {
            this.readSwaggerConfig(swaggerDefinition);
        }
        for (Method method : context.getCls().getDeclaredMethods()) {
            HashMap regexMap;
            String parsedPath;
            Path path;
            Optional IgnoreOptional;
            Optional notActionOptional;
            if (ReflectionUtils.isOverriddenMethod((Method)method, context.getCls()) || (notActionOptional = AnnotationUtils.findAnnotation(method.getClass(), NotAction.class)).isPresent() || (IgnoreOptional = AnnotationUtils.findAnnotation(method.getClass(), Ignore.class)).isPresent()) continue;
            Operation operation = new Operation();
            String httpMethod = null;
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            JFinalReaderExtension extension = new JFinalReaderExtension();
            String methodRoute = "/" + method.getName();
            Optional actionKeyOptional = AnnotationUtils.findAnnotation(method.getClass(), ActionKey.class);
            if (actionKeyOptional.isPresent()) {
                ActionKey actionKey = (ActionKey)actionKeyOptional.get();
                String actionValue = actionKey.value();
                methodRoute = actionValue.startsWith("/") ? actionValue : "/" + actionValue;
            }
            String operationPath = null;
            StringBuilder pathBuilder = new StringBuilder();
            if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getBasePath()) && !"/".equals(this.jFinalDocument.getBasePath())) {
                if (!this.jFinalDocument.getBasePath().startsWith("/")) {
                    pathBuilder.append("/");
                }
                pathBuilder.append(this.jFinalDocument.getBasePath());
            }
            if (StrUtil.isNotBlank((CharSequence)key) && !"/".equals(key)) {
                if (!key.startsWith("/")) {
                    pathBuilder.append("/");
                }
                pathBuilder.append(key);
            }
            pathBuilder.append(methodRoute);
            operationPath = pathBuilder.toString();
            if (operationPath == null) {
                operationPath = extension.getPath(context, method);
            }
            if (httpMethod == null && StrUtil.isBlank((CharSequence)(httpMethod = extension.getHttpMethod(context, method)))) {
                httpMethod = "post";
            }
            if (operationPath == null || httpMethod == null) continue;
            if (extension.isReadable(context)) {
                extension.setDeprecated(operation, method);
                extension.applyConsumes(context, operation, method);
                extension.applyProduces(context, operation, method);
                extension.applyOperationId(operation, method);
                extension.applySummary(operation, method);
                extension.applyDescription(operation, method);
                extension.applySchemes(context, operation, method);
                extension.applySecurityRequirements(context, operation, method);
                extension.applyTags(context, operation, method);
                extension.applyResponses(context, operation, method);
                extension.applyImplicitParameters(context, operation, method);
                extension.applyExtensions(context, operation, method);
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    extension.applyParameters(context, operation, genericParameterTypes[i], paramAnnotations[i]);
                }
            }
            if (httpMethod == null) continue;
            if (operation.getResponses() == null) {
                operation.response(200, new Response().description("OK"));
            }
            if ((path = this.swagger.getPath(parsedPath = PathUtils.parsePath((String)operationPath, regexMap = new HashMap()))) == null) {
                path = new Path();
                this.swagger.path(parsedPath, path);
            }
            path.set(httpMethod.toLowerCase(), operation);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readSwaggerConfig(SwaggerDefinition config) {
        int n;
        if (StrUtil.isNotBlank((CharSequence)config.basePath())) {
            this.swagger.setBasePath(config.basePath());
        }
        if (StrUtil.isNotBlank((CharSequence)config.host())) {
            this.swagger.setHost(config.host());
        }
        for (String string : config.consumes()) {
            if (!StrUtil.isNotBlank((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : config.produces()) {
            if (!StrUtil.isNotBlank((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        if (StrUtil.isNotBlank((CharSequence)config.externalDocs().value())) {
            ExternalDocs externalDocs = this.swagger.getExternalDocs();
            if (externalDocs == null) {
                externalDocs = new ExternalDocs();
                this.swagger.setExternalDocs(externalDocs);
            }
            externalDocs.setDescription(config.externalDocs().value());
            if (StrUtil.isNotBlank((CharSequence)config.externalDocs().url())) {
                externalDocs.setUrl(config.externalDocs().url());
            }
        }
        for (String string : config.securityDefinition().oAuth2Definitions()) {
            void var6_18;
            OAuth2Definition oAuth2Definition = new OAuth2Definition();
            OAuth2Definition.Flow flow = string.flow();
            if (flow.equals((Object)OAuth2Definition.Flow.ACCESS_CODE)) {
                OAuth2Definition oAuth2Definition2 = oAuth2Definition.accessCode(string.authorizationUrl(), string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.APPLICATION)) {
                OAuth2Definition oAuth2Definition3 = oAuth2Definition.application(string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.IMPLICIT)) {
                OAuth2Definition oAuth2Definition4 = oAuth2Definition.implicit(string.authorizationUrl());
            } else {
                OAuth2Definition oAuth2Definition5 = oAuth2Definition.password(string.tokenUrl());
            }
            for (Scope scope : string.scopes()) {
                var6_18.addScope(scope.name(), scope.description());
            }
            var6_18.setDescription(string.description());
            this.swagger.addSecurityDefinition(string.key(), (SecuritySchemeDefinition)var6_18);
        }
        String[] stringArray = new io.swagger.annotations.ApiKeyAuthDefinition[][]{config.securityDefinition().apiKeyAuthDefintions(), config.securityDefinition().apiKeyAuthDefinitions()};
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String apiKeyAuthConfig : string = stringArray[n]) {
                ApiKeyAuthDefinition apiKeyAuthDefinition = new ApiKeyAuthDefinition();
                apiKeyAuthDefinition.setName(apiKeyAuthConfig.name());
                apiKeyAuthDefinition.setIn(In.forValue((String)apiKeyAuthConfig.in().toValue()));
                apiKeyAuthDefinition.setDescription(apiKeyAuthConfig.description());
                this.swagger.addSecurityDefinition(apiKeyAuthConfig.key(), (SecuritySchemeDefinition)apiKeyAuthDefinition);
            }
        }
        stringArray = new io.swagger.annotations.BasicAuthDefinition[][]{config.securityDefinition().basicAuthDefinions(), config.securityDefinition().basicAuthDefinitions()};
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String basicAuthConfig : string = stringArray[n]) {
                BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
                basicAuthDefinition.setDescription(basicAuthConfig.description());
                this.swagger.addSecurityDefinition(basicAuthConfig.key(), (SecuritySchemeDefinition)basicAuthDefinition);
            }
        }
        for (String string : config.tags()) {
            if (!StrUtil.isNotBlank((CharSequence)string.name())) continue;
            Tag tag = new Tag();
            tag.setName(string.name());
            tag.setDescription(string.description());
            if (StrUtil.isNotBlank((CharSequence)string.externalDocs().value())) {
                tag.setExternalDocs(new ExternalDocs(string.externalDocs().value(), string.externalDocs().url()));
            }
            tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])string.extensions()));
            this.swagger.addTag(tag);
        }
        for (String string : config.schemes()) {
            if (string == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)string.name()));
        }
    }

    private void readInfoConfig() {
        Info info;
        if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getBasePath())) {
            this.swagger.setBasePath(this.jFinalDocument.getBasePath());
        }
        if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getHost())) {
            this.swagger.setHost(this.jFinalDocument.getHost());
        }
        if ((info = this.swagger.getInfo()) == null) {
            info = new Info();
            this.swagger.setInfo(info);
        }
        if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getDescription())) {
            info.setDescription(this.jFinalDocument.getDescription());
        }
        if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getTitle())) {
            info.setTitle(this.jFinalDocument.getTitle());
        }
        info.setVersion("2.0");
        if (StrUtil.isNotBlank((CharSequence)this.jFinalDocument.getContact())) {
            Contact contact = info.getContact();
            if (contact == null) {
                contact = new Contact();
                info.setContact(contact);
            }
            contact.setName(this.jFinalDocument.getContact());
        }
    }
}

