/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.jfinal.context;

import io.swagger.models.Tag;
import java.util.LinkedHashMap;
import java.util.Map;

public class TagContext {
    private Class<?> controllerClass;
    private String name;
    private String description;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    public TagContext(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    public void addExtensions(String key, Object value) {
        this.vendorExtensions.put(key, value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public Tag build() {
        Tag tag = new Tag();
        tag.setName(this.name);
        tag.setDescription(this.description);
        if (this.vendorExtensions.size() > 0) {
            tag.setVendorExtensions(this.vendorExtensions);
        }
        return tag;
    }
}

