/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.jfinal;

import com.github.xiaoymin.knife4j.core.io.ResourceUtil;
import com.github.xiaoymin.knife4j.jfinal.JFinalDocument;
import com.github.xiaoymin.knife4j.jfinal.JFinalDocumentation;
import com.github.xiaoymin.knife4j.jfinal.core.Reader;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFinalSwagger {
    Logger logger = LoggerFactory.getLogger(JFinalSwagger.class);
    public static final JFinalSwagger me = new JFinalSwagger();
    private List<JFinalDocument> jFinalDocumentList = new ArrayList<JFinalDocument>();
    private Map<String, Swagger> swaggerMap = new HashMap<String, Swagger>();

    private JFinalSwagger() {
    }

    public JFinalSwagger addDocs(JFinalDocument ... jFinalDocuments) {
        if (jFinalDocuments == null || jFinalDocuments.length == 0) {
            throw new IllegalArgumentException("\u6587\u6863\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.jFinalDocumentList.addAll(Arrays.asList(jFinalDocuments));
        return this;
    }

    public void start() {
        this.logger.debug("Start--->JFinal\u9879\u76ee\u521d\u59cb\u5316Swagger\u6587\u6863");
        for (JFinalDocument jFinalDocument : this.jFinalDocumentList) {
            Swagger swagger = new Swagger();
            Set classSet = new ResourceUtil().find(jFinalDocument.getPackagePaths().toArray(new String[0])).getClasses();
            Reader.read(swagger, jFinalDocument);
            this.swaggerMap.put(jFinalDocument.getName(), swagger);
        }
        this.logger.debug("End--->JFinal\u9879\u76ee\u521d\u59cb\u5316Swagger\u6587\u6863");
    }

    public Swagger getSwagger(String name) {
        Iterator<Swagger> iterator;
        Swagger swagger = this.swaggerMap.get(name);
        if (swagger == null && this.swaggerMap.size() > 0 && (iterator = this.swaggerMap.values().iterator()).hasNext()) {
            swagger = iterator.next();
        }
        return swagger;
    }

    public List<JFinalDocumentation> getAllDocumentation() {
        ArrayList<JFinalDocumentation> jFinalDocumentationList = new ArrayList<JFinalDocumentation>();
        if (this.jFinalDocumentList.size() > 0) {
            this.jFinalDocumentList.forEach(jFinalDocument -> {
                String url = "/v2/api-docs?group=" + jFinalDocument.getName();
                jFinalDocumentationList.add(new JFinalDocumentation(jFinalDocument.getName(), jFinalDocument.getOrder(), url, url));
            });
        }
        return jFinalDocumentationList;
    }
}

