/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.jfinal;

import com.github.xiaoymin.knife4j.jfinal.model.JFinalControllerKey;
import com.jfinal.core.Controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JFinalDocument {
    private Integer order;
    private String name;
    private String title;
    private String description;
    private String contact;
    private String host;
    private String basePath;
    private List<String> packagePaths;
    private List<JFinalControllerKey> jFinalControllerKeys;

    public JFinalDocument(Integer order, String name, String title, String description, String contact, String host, String basePath, List<String> packagePaths, List<JFinalControllerKey> jFinalControllerKeys) {
        this.order = order;
        this.name = name;
        this.title = title;
        this.description = description;
        this.contact = contact;
        this.host = host;
        this.basePath = basePath;
        this.packagePaths = packagePaths;
        this.jFinalControllerKeys = jFinalControllerKeys;
        if (this.packagePaths == null) {
            this.packagePaths = new ArrayList<String>();
        }
        if (this.jFinalControllerKeys == null) {
            this.jFinalControllerKeys = new ArrayList<JFinalControllerKey>();
        }
    }

    public JFinalDocument addController(String key, Class<? extends Controller> clazz) {
        this.jFinalControllerKeys.add(new JFinalControllerKey(key, clazz));
        return this;
    }

    public JFinalDocument addController(JFinalControllerKey ... jFinalControllerKeys) {
        if (jFinalControllerKeys != null && jFinalControllerKeys.length > 0) {
            this.jFinalControllerKeys.addAll(Arrays.asList(jFinalControllerKeys));
        }
        return this;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContact() {
        return this.contact;
    }

    public List<String> getPackagePaths() {
        return this.packagePaths;
    }

    public String getHost() {
        return this.host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<JFinalControllerKey> getjFinalControllerKeys() {
        return this.jFinalControllerKeys;
    }

    public static final class Builder {
        private Integer order = 1;
        private String name;
        private String title;
        private String description;
        private String contact;
        private String host;
        private String basePath;
        private List<String> packagePaths = new ArrayList<String>();
        private List<JFinalControllerKey> jFinalControllerKeys = new ArrayList<JFinalControllerKey>();

        public Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder contact(String contact) {
            this.contact = contact;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder paths(String ... paths) {
            if (paths != null && paths.length > 0) {
                this.packagePaths.addAll(Arrays.asList(paths));
            }
            return this;
        }

        public Builder addController(String key, Class<? extends Controller> clazz) {
            this.jFinalControllerKeys.add(new JFinalControllerKey(key, clazz));
            return this;
        }

        public Builder addController(JFinalControllerKey ... jFinalControllerKeys) {
            if (jFinalControllerKeys != null && jFinalControllerKeys.length > 0) {
                this.jFinalControllerKeys.addAll(Arrays.asList(jFinalControllerKeys));
            }
            return this;
        }

        public JFinalDocument build() {
            return new JFinalDocument(this.order, this.name, this.title, this.description, this.contact, this.host, this.basePath, this.packagePaths, this.jFinalControllerKeys);
        }
    }
}

