/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.filter;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasicAuthFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBasicAuthFilter.class);
    public static final String BASIC = "Basic";
    protected List<Pattern> urlFilters = new ArrayList<Pattern>();

    protected AbstractBasicAuthFilter() {
        this.urlFilters.add(Pattern.compile(".*?/doc\\.html.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/v2/api-docs.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/v2/api-docs-ext.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources/configuration/ui.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources/configuration/security.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-ui.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/v3/api-docs.*", 2));
    }

    public void addRule(String rule) {
        this.urlFilters.add(Pattern.compile(rule, 2));
    }

    public void addRule(Collection<String> rules) {
        if (rules != null && !rules.isEmpty()) {
            rules.forEach(this::addRule);
        }
    }

    protected boolean match(String uri) {
        if (uri != null) {
            String newUri = uri.replaceAll("/+", "/");
            for (Pattern pattern : this.getUrlFilters()) {
                if (!pattern.matcher(newUri).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected String decodeBase64(String source) {
        String decodeStr = null;
        if (source != null) {
            try {
                byte[] bytes = Base64.getDecoder().decode(source);
                decodeStr = new String(bytes);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return decodeStr;
    }

    @Generated
    public List<Pattern> getUrlFilters() {
        return this.urlFilters;
    }
}

