/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover;

import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ServiceRouterHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceRouterHolder.class);
    final List<String> service;
    final Set<String> excludeService;
    final ServiceDiscoverHandler discoverHandler;

    public void add(OpenAPI2Resource resource) {
        if (resource == null) {
            log.warn("resource is null");
            return;
        }
        log.debug("add resource:{}", (Object)resource);
        this.discoverHandler.add(resource);
    }

    public void clearService() {
        Set<OpenAPI2Resource> openAPI2Resources = this.discoverHandler.getGatewayResources();
        if (CollectionUtils.isEmpty(openAPI2Resources)) {
            return;
        }
        List<String> downService = openAPI2Resources.stream().map(OpenAPI2Resource::getServiceName).filter(s -> !this.service.contains(s)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(downService)) {
            return;
        }
        downService.forEach(this.discoverHandler::remove);
    }

    @Generated
    public List<String> getService() {
        return this.service;
    }

    @Generated
    public Set<String> getExcludeService() {
        return this.excludeService;
    }

    @Generated
    public ServiceDiscoverHandler getDiscoverHandler() {
        return this.discoverHandler;
    }

    @Generated
    public ServiceRouterHolder(List<String> service, Set<String> excludeService, ServiceDiscoverHandler discoverHandler) {
        this.service = service;
        this.excludeService = excludeService;
        this.discoverHandler = discoverHandler;
    }
}

